% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvparam.R
\name{CVParam}
\alias{CVParam}
\alias{charIsCVParam}
\alias{cvCharToCVPar}
\alias{as.character.CVParam}
\alias{show,CVParam-method}
\alias{rep,CVParam-method}
\title{Controlled Vocabulary}
\usage{
CVParam(label, name, accession, value, exact = TRUE)

\S4method{show}{CVParam}(object)

\S4method{rep}{CVParam}(x, times)
}
\arguments{
\item{label}{`character(1)` with the ontology label. If missing, a
user-defined parameter is created.}

\item{name}{`character(1)` with the name of the `CVParam` to be
constructed. This argument can be omitted if `accession` is
used and `label` is not missing.}

\item{accession}{`character(1)` with the accession of the
`CVParam` to be constructed. This argument can be omitted if
`name` is used. Ignored for user-defined instances.}

\item{value}{`character(1)` with the value of the `CVParam` o be
constructed. This argument is optional.}

\item{exact}{`logical(1)` defining whether the query to retrieve
the `accession` (when `name` is used) should be an exact
match.}

\item{object}{`CVParam` object.}

\item{x}{`CVParam` to be repeated.}

\item{times}{`numeric(1)` defining the number of repetitions.}
}
\description{
`CVParam` objects instantiate controlled vocabulary entries.
}
\section{Methods}{


- `charIsCVParam(x)` checks if `x`, a character of the form
  `"[ONTO, ACCESSION, NAME, VALUE]"`, is a valid (possibly
  user-defined) `CVParam`. `"ONTO"` is the ontology label
  (prefix), `"ACCESSION"` is the term accession number, `"NAME"`
  is the term's name and `"VALUE"` is the value. Note that only
  the syntax validity is verified, not the semantics. See example
  below.

- `coerce(from = "CVParam", to = "character")` coerces `CVParam`
  `from` to a `character` of the following form: `[label,
  accession, name, value]`. `as.character` is also defined.

- `coerce(from = "character", to = "CVParam")` coerces `character`
  `from` to a `CVParam`. `as.CVParam` is also defined. If a
  `label` is absent, the `character` is converted to a User param,
  else, the `label` and `accession` are used to query the Ontology
  Lookup Service (see [OlsSearch()]). If a `name` is provided and
  does not match the retrieved name, a warning is thrown.

  This function is vectorised; if the `from` character is of
  length greater than 1, then a list of `CVParam` is returned. The
  queries to the OLS are processed one-by-one, though.
}

\examples{

## User param
CVParam(name = "A user param", value = "the value")
## CVParam ESI from PSI's Mass Spectrometry ontology
olsTerm("GO", "GO:0035145")
(eej <- CVParam(label = "GO", accession = "GO:0035145"))
class(eej)

## From a CVParam object to a character
cv <- as(eej, "character")
cv ## note the quotes

## From a character object to a CVParam
as(cv, "CVParam")
as("[GO, GO:0035145, , ]", "CVParam") ## no name
as("[GO, GO:0035145, exon-exon junction complex, ]", "CVParam")
as(c(cv, cv), "CVParam") ## more than 1 character

x <- c("[MS, MS:1000073, , ]", ## valid CV param
       "[, , Hello, world]",   ## valid User param
       "[this, one is, not, valid]", ## not valid
       "[ , , , ]") ## not valid

stopifnot(charIsCVParam(x) == c(TRUE, TRUE, FALSE, FALSE))

## A list of expected valid and non-valid entries
rols:::validCVchars
rols:::notvalidCVchars
}
\author{
Laurent Gatto
}
