% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFC.R
\name{plotFC}
\alias{plotFC}
\title{Estimate And Plot Fold Change Accuracy}
\usage{
plotFC(dat, positive, fcsign, constant = 0.5, loessspan = 1/3,
  thresholds = c(1, 6), ...)
}
\arguments{
\item{dat}{A \code{rnaseqcomp} S4 class object.}

\item{positive}{A logical vector with length equivalent to row
number of matrices in \code{dat@quantData}. \code{TRUE} means true
differential and \code{FALSE} means true non-differential, while
missing value \code{NA} means unknown.}

\item{fcsign}{A numeric vector with length equivalent to row
number of matrices in \code{dat@quantData}. Only values {1, -1, 0, NA}
are allowed. 1 means upregulated in second cell line, -1 means
downregulated in second cell line, and 0 means no change. If elements
in \code{fcsign} is NA or correspond to \code{NA} in \code{positive},
these elements will be ignored in estimation.}

\item{constant}{A numeric constant that is added to
quantifications before fold changes calculation. (default: 0.5)}

\item{loessspan}{A numeric number indicating span used
for loess smooth. Details see
\code{loess.smooth} function. (Default: 1/3)}

\item{thresholds}{A numeric vector defining cutoffs on fold changes
as the points to make threshold averaging on ROC curves.
(default: seq(12, 0, len = 300))}

\item{...}{Parameters for base function \code{plot}.}
}
\value{
\item{plot}{Fold change plots for all the quantification pipelines.}
\item{list}{A list of two numeric vectors indicating median and
standard error of fold changes in three
different levels of detrended logsignals.}
}
\description{
For each pipeline, differential expression is
estimated by fold change on mean signals across replicates of
cell lines. For features that are truely differential
expressed, their fold changes levels are summarized based on
different levels of detrended logsignals.
}
\examples{
data(simdata)
condInfo <- factor(simdata$samp$condition)
repInfo <- factor(simdata$samp$replicate)
evaluationFeature <- rep(TRUE, nrow(simdata$meta))
calibrationFeature <- simdata$meta$house & simdata$meta$chr == 'chr1'
unitReference <- 1
dat <- signalCalibrate(simdata$quant, condInfo, repInfo, evaluationFeature,
calibrationFeature, unitReference, calibrationFeature2 = calibrationFeature)
## only select the true differential that have exact fold changes
simdata$meta$fcsign[simdata$meta$fcstatus == "off.on"] <- NA
plotFC(dat,simdata$meta$positive,simdata$meta$fcsign)
}
