% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleCloseByRegion.R
\name{SingleCloseByRegion}
\alias{SingleCloseByRegion}
\title{Extracts clusters of RNA editing sites located closely in a single 
  genomic region.}
\usage{
SingleCloseByRegion(region_df, rnaEditMatrix, maxGap = 50, minSites = 3)
}
\arguments{
\item{region_df}{A data frame with the input genomic region. Please make 
sure columns \code{seqnames}, \code{start}, and \code{end} are included in 
the data frame.}

\item{rnaEditMatrix}{A matrix (or data frame) of RNA editing level values 
for individual sites, with row names as site IDs in the form of
"chrAA:XXXXXXXX", and column names as sample IDs. Please make sure to
follow the format of example dataset (\code{data(rnaedit_df)}).}

\item{maxGap}{An integer, genomic locations within \code{maxGap} from each
other are placed into the same cluster. Defaults to 50.}

\item{minSites}{An integer, minimum number of edited sites for a
cluster to be selected for output. Defaults to 3.}
}
\value{
A GRanges object containing genomic locations of RNA editing sites
  located closely within the single input pre-defined genomic region.
}
\description{
Extracts clusters of RNA editing sites located closely in an 
input genomic region.
}
\details{
The algorithm of this function is based on the
  \code{\link[bumphunter]{clusterMaker}} function in the \code{bumphunter}
  R package. Each cluster is essentially a group of sites such that
  two consecutive sites in the cluster are separated by less than
  \code{maxGap}.
}
\examples{
  data(rnaedit_df)
  
  exm_region <- data.frame(
    seqnames = "chr1",
    start =  28691093,
    end = 28826881, 
    stringsAsFactors = FALSE
  )
  
  SingleCloseByRegion(
    region_df = exm_region,
    rnaEditMatrix = rnaedit_df,
    maxGap = 50,
    minSites = 3
  )  
  
}
\keyword{internal}
