% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_FindCorrelatedRegions.R
\name{FindCorrelatedRegions}
\alias{FindCorrelatedRegions}
\title{Find contiguous co-edited subregions.}
\usage{
FindCorrelatedRegions(
  sites_df,
  featureType = c("site", "cpg"),
  minSites_int = 3
)
}
\arguments{
\item{sites_df}{An output data frame from function \code{MarkCoeditedSites},
with variables \code{site, keep, ind, r_drop}. Please see
\code{\link{MarkCoeditedSites}} for details.}

\item{featureType}{Feature type, Defaults to \code{"site"}.}

\item{minSites_int}{An integer indicates the minimum number of sites to be
considered a contiguous co-edited region.}
}
\value{
A data frame with the following columns:
  \itemize{
    \item{\code{site} : }{site ID.}
    \item{\code{subregion} : }{index for each output contiguous co-edited
    region.}
  }
}
\description{
Find contiguous co-edited subregions based on the output file
  from function \code{\link{MarkCoeditedSites}}.
}
\examples{
  data(t_rnaedit_df)
   
  ordered_cols <- OrderSitesByLocation(
    sites_char = colnames(t_rnaedit_df),
    output = "vector"
  )
  exm_data <- t_rnaedit_df[, ordered_cols]
   
  exm_sites <- MarkCoeditedSites(
    rnaEditCluster_mat = exm_data,
    method = "spearman"
  )
  
  FindCorrelatedRegions(
    sites_df = exm_sites,
    featureType = "site"
  )
   
}
\keyword{internal}
