% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframe_summary_events_HL_int.r
\name{dataframe_summary_events_HL_int}
\alias{dataframe_summary_events_HL_int}
\title{\subsection{=========================================================================
dataframe_summary_events_HL_int}{

dataframe_summary_events_HL_int creates one table with all events between
the segments
}}
\usage{
dataframe_summary_events_HL_int(data, data_annotation)
}
\arguments{
\item{data}{SummarizedExperiment: the input data frame with correct format.}

\item{data_annotation}{dataframe: dataframe from processed gff3 file.}
}
\value{
\describe{
\item{event:}{String, event type.}
\item{p_value:}{Integer, p_value of the event.}
\item{p_adjusted:}{Integer, p_value adjusted.}
\item{FC_HL:}{Integer, the fold change value of 2 HL fragments.}
\item{FC_intensity:}{Integer, the fold change value of 2 intensity
fragments.}
\item{FC_HL_adapted:}{Integer, the fold change of half-life/ fold change
of intensity, position of the half-life fragment is adapted to intensity
fragment.}
\item{FC_HL_FC_intensity:}{Fold change of half-life/ fold change of
intensity.}
\item{feature_type:}{String, region annotation covering the fragments.}
\item{gene:}{String, gene annotation covering the fragments.}
\item{locus_tag:}{String, locus_tag annotation covering the fragments.}
\item{strand:}{Boolean. The bin/probe specific strand (+/-).}
\item{TU:}{String, The overarching transcription unit.}
\item{segment_1:}{String, the first segment of the event, includes the
segment, TU, delay fragment in case of ps or iTSS_I. The rest of the
events include HL fragment and could be extended intensity fragment.}
\item{segment_2:}{String, the second fragment of the two of fragments
subjected to analysis.}
\item{event_duration:}{Integer, the difference (min) between 2 delay
fragment when ps or iTSS_I happen.}
\item{gap_fragments:}{Integer, length in position (nt), calculated by the
difference between the last position of the first fragment and the first
position of the second fragment.}
\item{features:}{Integer, number of fragements involved on the event}
}
}
\description{
The dataframe_summary_events_HL_int creates one table with the following
columns: event, features, p_value, event_position, position,
region, gene, locus_tag, strand, TU, segment_1, segment_2, length, FC_HL,
FC_intensity, FC_HL/FC_intensity.
}
\examples{
if(!require(SummarizedExperiment)){
suppressPackageStartupMessages(library(SummarizedExperiment))
}
data(stats_minimal)
dataframe_summary_events_HL_int(data = stats_minimal,
data_annotation = metadata(stats_minimal)$annot[[1]])

}
