% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_pen.r
\name{make_pen}
\alias{make_pen}
\title{make_pen assigns automatically penalties}
\usage{
make_pen(
  probe,
  FUN,
  cores = 1,
  logs,
  dpt = 1,
  smpl_min = 10,
  smpl_max = 100,
  sta_pen = 0.5,
  end_pen = 4.5,
  rez_pen = 9,
  sta_pen_out = 0.5,
  end_pen_out = 3.5,
  rez_pen_out = 7
)
}
\arguments{
\item{probe}{data frame: data frame combined data by column}

\item{FUN}{function: one of the four bottom level functions (see details)}

\item{cores}{integer: the number of assigned cores for the task}

\item{logs}{numeric vector: the logbook vector.}

\item{dpt}{integer: the number of times a full iteration cycle is repeated
with a more narrow range based on the previous cycle.}

\item{smpl_min}{integer: the smaller end of the sampling size.}

\item{smpl_max}{integer: the larger end of the sampling size.}

\item{sta_pen}{numeric: the lower starting penalty.}

\item{end_pen}{numeric: the higher starting penalty.}

\item{rez_pen}{numeric: the number of penalties iterated within the penalty
range.}

\item{sta_pen_out}{numeric: the lower starting outlier penalty.}

\item{end_pen_out}{numeric: the higher starting outlier penalty.}

\item{rez_pen_out}{numeric: the number of outlier penalties iterated within
the outlier penalty range.}
}
\value{
A list with 4 items:
\describe{
\item{logbook:}{The logbook vector containing all penalty information}
\item{penalties:}{a vector with the respective penalty and outlier
penalty}
\item{correct:}{a matrix of the correct splits}
\item{wrong:}{a matrix of the incorrect splits}
}
}
\description{
make_pen calls one of four available penalty functions to automatically
assign penalties for the dynamic programming.
The two functions to be called are:
\enumerate{
\item fragment_HL_pen
\item fragment_inty_pen
}
}
\details{
The two functions called return the amount of statistically correct and
statistically wrong splits at a specific pair of penalties.
'make_pen' iterates over many penalty pairs and picks the most suitable pair
based on the difference between wrong and correct splits.
The sample size, penalty range and resolution as well as the number of cycles
can be customized.
The primary start parameters create a matrix with n = rez_pen rows and
n = rez_pen_out columns with values between sta_pen/sta_pen_out
and end_pen/end_pen_out. The best penalty pair is picked. If dept is bigger
than 1 the same process is repeated with a new matrix of the same size
based on the result of the previous cycle. Only position segments with length
within the sample size range are considered for the penalties to increase
run time.
}
\examples{
data(df_comb_minimal)

df_comb_minimal$distance_HL <- df_comb_minimal$half_life.cdt1 -
df_comb_minimal$half_life.cdt2

df_comb_minimal$distance_int <- df_comb_minimal$logFC_int

pen_HL <- make_pen(
  probe = df_comb_minimal, FUN = rifiComparative:::fragment_HL_pen, 
  cores = 2, logs = as.numeric(rep(NA, 8)), dpt = 1, smpl_min = 10, 
  smpl_max = 50, sta_pen = 0.5, end_pen = 4.5, rez_pen = 9, sta_pen_out = 0.5,
  end_pen_out = 3.5, rez_pen_out = 7
)

pen_int <- make_pen(
  probe = df_comb_minimal, FUN = rifiComparative:::fragment_inty_pen, 
  cores = 2, logs = as.numeric(rep(NA, 8)), dpt = 1, smpl_min = 10, 
  smpl_max = 50, sta_pen = 0.5, end_pen = 4.5, rez_pen = 9, sta_pen_out = 0.5,
  end_pen_out = 3.5, rez_pen_out = 7
)

}
