% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FLOSS.R
\name{FLOSS}
\alias{FLOSS}
\title{Fragment Length Organization Similarity Score (FLOSS)}
\usage{
FLOSS(
  reads,
  ref,
  CDS,
  readLengths = c(26:34),
  level = c("tx", "gene"),
  draw = FALSE,
  ignore.seqlevelsStyle = FALSE
)
}
\arguments{
\item{reads}{Output of \link{getPsiteCoordinates}}

\item{ref}{Refercence id list. If level is set to tx, the id should be
transcript names. If level is set to gene, the id should be gene id.}

\item{CDS}{Output of \link{prepareCDS}}

\item{readLengths}{Read length used for calculation}

\item{level}{Transcript or gene level}

\item{draw}{Plot FLOSS vs total reads or not.}

\item{ignore.seqlevelsStyle}{Ignore the sequence name style detection or not.}
}
\value{
A data frame with colnames as id, FLOSS, totalReads,
wilcox.test.pval, cook's distance.
}
\description{
The FLOSS will be calculated from a histogram of
read lengths for footprints on a transcript or reading frame.
}
\examples{
library(Rsamtools)
bamfilename <- system.file("extdata", "RPF.WT.1.bam",
                           package="ribosomeProfilingQC")
yieldSize <- 10000000
bamfile <- BamFile(bamfilename, yieldSize = yieldSize)
pc <- getPsiteCoordinates(bamfile, bestpsite=13)
#library(txdbmaker)
library(BSgenome.Drerio.UCSC.danRer10)
#txdb <- makeTxDbFromGFF(system.file("extdata",
 #         "Danio_rerio.GRCz10.91.chr1.gtf.gz",
 #         package="ribosomeProfilingQC"),
 #         organism = "Danio rerio",
 #         chrominfo = seqinfo(Drerio)["chr1"],
 #         taxonomyId = 7955)
#CDS <- prepareCDS(txdb)
CDS <- readRDS(system.file("extdata", "CDS.rds",
                           package="ribosomeProfilingQC"))
set.seed(123)
ref <- sample(unique(CDS$gene_id), 100)
fl <- FLOSS(pc, ref, CDS, level="gene")
}
\references{
1: Ingolia NT, Brar GA, Stern-Ginossar N, Harris MS,
Talhouarne GJ, Jackson SE, Wills MR, Weissman JS. Ribosome profiling
reveals pervasive translation outside
of annotated protein-coding genes. Cell Rep. 2014 Sep 11;8(5):1365-79. doi:
10.1016/j.celrep.2014.07.045. Epub 2014 Aug 21. PubMed PMID: 25159147; PubMed
Central PMCID: PMC4216110.
}
