% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region_count_functions.R
\name{plot_length_distribution}
\alias{plot_length_distribution}
\title{Plots the length distribution}
\usage{
plot_length_distribution(
  x,
  region,
  experiment,
  range.lower,
  range.upper,
  fraction = FALSE,
  title = "Length Distribution"
)
}
\arguments{
\item{x}{A 'Ribo' object or a DataFrame generated from \code{\link{get_region_counts}}}

\item{region}{the region of interest}

\item{experiment}{a list of experiment names}

\item{range.lower}{a lower bounds for a read length range}

\item{range.upper}{an upper bounds for a read length range}

\item{fraction}{logical value that, if TRUE, presents the count as a fraction of the total reads in the given ranges}

\item{title}{a title for the generated plot}
}
\value{
A 'ggplot' of the length distribution
}
\description{
The function \code{\link{plot_length_distribution}} can take either a DataFrame
or a "Ribo" object to generate a line graph of the length distributions from
range.lower to range.upper.
}
\details{
The param 'fraction' will plot the fractions of each length relative
to the total sum of the read length range provided by param 'range.lower'
and 'range.upper'. When fraction is set to FALSE, the total count of each
read length is plotted.

When given a "Ribo" object, \code{\link{plot_length_distribution}} calls
\code{\link{get_region_counts}} to retrieve the necessary information
for plotting.

The user can instead provide a DataFrame with the same structure as the
output of the \code{\link{get_region_counts}} function where the 'transcript'
parameter is set to FALSE and 'length' parameters is the default value of
TRUE. This also means that the many of the remaining parameters of the
\code{\link{plot_length_distribution}} function are not necessary. The run
time becomes substantially faster when \code{\link{plot_region_counts}} is
given the direct DataFrame to plot. Note that there is no manipulation by
this function on the DataFrame. This responsibility is given to the user
and allows for more control.
}
\examples{
#ribo object use case

#generate the ribo object
file.path <- system.file("extdata", "sample.ribo", package = "ribor")
sample <- Ribo(file.path)

#specify experiments of interest
experiments <- c("Hela_1", "Hela_2", "WT_1")

plot_length_distribution(x = sample,
                         region = "CDS",
                         range.lower = 2,
                         range.upper = 5,
                         experiment = experiments,
                         fraction = TRUE)


#DataFrame use case
#obtains the region counts at each individual read length, summed across every transcript
region.counts <- get_length_distribution(ribo.object = sample,
                                         region      = "CDS",
                                         range.lower = 2,
                                         range.upper = 5,
                                         experiment  = experiments)

#the param 'length' must be set to FALSE and param 'transcript' must be set
#to TRUE to use a DataFrame
plot_length_distribution(region.counts)


}
\seealso{
\code{\link{get_region_counts}} to generate a DataFrame that can
be provided as input,
\code{\link{Ribo}} to create a ribo.object that can be provided as input
}
