% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_binding_sites.R
\name{get_binding_sites}
\alias{get_binding_sites}
\title{Get the binding sites for a Transcription Factor (TF)}
\usage{
get_binding_sites(regulondb, transcription_factor, output_format = "GRanges")
}
\arguments{
\item{regulondb}{A \code{\link[=regulondb]{regulondb()}} object.}

\item{transcription_factor}{name of the transcription factor.}

\item{output_format}{The output object. Can be either a \code{GRanges} (default)
or \code{Biostrings}.}
}
\value{
Either a GRanges object or a Biostrings object summarizing
information
about the binding sites of the transcription factors.
}
\description{
Retrieve the binding sites and genome location for a given
transcription factor.
}
\examples{
## Connect to the RegulonDB database if necessary
if (!exists("regulondb_conn")) regulondb_conn <- connect_database()

## Build the regulon db object
e_coli_regulondb <-
    regulondb(
        database_conn = regulondb_conn,
        organism = "E.coli",
        database_version = "1",
        genome_version = "1"
    )

## Get the binding sites for AraC
get_binding_sites(e_coli_regulondb, transcription_factor = "AraC")
}
\author{
José Alquicira Hernández, Jacques van Helden, Joselyn Chávez
}
