% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_RegspliceResults.R
\docType{class}
\name{RegspliceResults-class}
\alias{RegspliceResults-class}
\alias{RegspliceResults}
\alias{gene_IDs}
\alias{gene_IDs,RegspliceResults-method}
\alias{p_vals}
\alias{p_vals,RegspliceResults-method}
\alias{p_adj}
\alias{p_adj,RegspliceResults-method}
\alias{LR_stats}
\alias{LR_stats,RegspliceResults-method}
\alias{df_tests}
\alias{df_tests,RegspliceResults-method}
\title{RegspliceResults objects.}
\usage{
RegspliceResults(gene_IDs)

gene_IDs(x)

\S4method{gene_IDs}{RegspliceResults}(x)

p_vals(x)

\S4method{p_vals}{RegspliceResults}(x)

p_adj(x)

\S4method{p_adj}{RegspliceResults}(x)

LR_stats(x)

\S4method{LR_stats}{RegspliceResults}(x)

df_tests(x)

\S4method{df_tests}{RegspliceResults}(x)
}
\arguments{
\item{gene_IDs}{Gene identifiers or names (character vector).}

\item{x}{\code{RegspliceResults} object (for accessor functions).}
}
\value{
Returns an empty \code{RegspliceResults} object.
}
\description{
\code{RegspliceResults} objects contain the results of a \code{regsplice} analysis.
}
\details{
\code{RegspliceResults} objects are created with the constructor function
\code{RegspliceResults()}, which requires the gene IDs as an argument.

Once created, \code{RegspliceResults} objects are then populated using the functions 
\code{\link{fitRegMultiple}}, \code{\link{fitNullMultiple}},
\code{\link{fitFullMultiple}}, and \code{\link{LRTests}}.

The function \code{\link{summaryTable}} can be used to display a summary table of the
results.
}
\section{Fields}{

\describe{
\item{\code{gene_IDs}}{Gene identifiers or names (character vector).}

\item{\code{fit_reg_dev}}{Deviance of fitted regularized (lasso) models from 
\code{\link{fitRegMultiple}}.}

\item{\code{fit_reg_df}}{Degrees of freedom of fitted regularized (lasso) models from 
\code{\link{fitRegMultiple}}.}

\item{\code{fit_null_dev}}{Deviance of fitted null models from 
\code{\link{fitNullMultiple}}.}

\item{\code{fit_null_df}}{Degrees of freedom of fitted null models from 
\code{\link{fitNullMultiple}}.}

\item{\code{fit_full_dev}}{Deviance of fitted full models from 
\code{\link{fitFullMultiple}}.}

\item{\code{fit_full_df}}{Degrees of freedom of fitted full models from 
\code{\link{fitFullMultiple}}.}

\item{\code{p_vals}}{Raw p-values (numeric vector).}

\item{\code{p_adj}}{Multiple testing adjusted p-values (Benjamini-Hochberg false discovery 
rates, FDR).}

\item{\code{LR_stats}}{Likelihood ratio test statistics.}

\item{\code{df_tests}}{Degrees of freedom of likelihood ratio tests.}
}}

\section{Accessor functions}{


\itemize{
\item \code{gene_IDs()}: Accesses gene identifiers or names.
\item \code{p_vals()}: Accesses raw p-values.
\item \code{p_adj()}: Accesses multiple testing adjusted p-values (Benjamini-Hochberg false discovery rates, FDR).
\item \code{LR_stats()}: Accesses likelihood ratio test statistics.
\item \code{df_tests()}: Accesses degrees of freedom of likelihood ratio tests.
}
}

\examples{
# initialize RegspliceResults object
gene_IDs <- paste0("gene", 1:5)
RegspliceResults(gene_IDs)

}
\seealso{
\code{\link{fitRegMultiple}} \code{\link{fitNullMultiple}}
  \code{\link{fitFullMultiple}} \code{\link{LRTests}} \code{\link{summaryTable}}
}
