% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{gds_idat2rg}
\alias{gds_idat2rg}
\title{Get IDATs as an RGChannelSet from GEO/GDS}
\usage{
gds_idat2rg(
  gsmvi,
  rmdl = TRUE,
  ext = "gz",
  dfp = "./idats/",
  burl = paste0("ftp://ftp.ncbi.nlm.nih.gov/", "geo/samples/"),
  silent = TRUE
)
}
\arguments{
\item{gsmvi}{A vector of GSM IDs (alphanumeric character strings).}

\item{rmdl}{Whether to remove downloaded IDAT files when finished
(default TRUE).}

\item{ext}{Extension for downloaded files (default "gz").}

\item{dfp}{Destination for IDAT downloads.}

\item{burl}{Base URL string for the IDAT query (default 
"ftp://ftp.ncbi.nlm.nih.gov/geo/samples/").}

\item{silent}{Whether to suppress warnings on download removal 
(default TRUE).}
}
\value{
An RGChannelSet object
}
\description{
Queries and downloads GSM IDAT files in GEO Data Sets db, then 
returns the assay data as an "RGChannelSet", calling gds_idatquery()
 then minfi::read.metharray().
}
\examples{
gsmvi <- c("GSM2465267", "GSM2814572")
fpath <- file.path(tempdir(), "gds_idat2rg_example")
rg <- try(gds_idat2rg(gsmvi, dfp = fpath))
}
\seealso{
gds_idatquery(), read.metharray()
}
