% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRPKM.R
\name{getRPKM}
\alias{getRPKM}
\title{Compute an RPKM matrix based on a RangedSummarizedExperiment object}
\usage{
getRPKM(rse, length_var = "bp_length", mapped_var = NULL)
}
\arguments{
\item{rse}{A \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class}
object as downloaded with \link{download_study}.}

\item{length_var}{A length 1 character vector with the column name from
\code{rowData(rse)} that has the coding length. For gene level objects
from recount this is \code{bp_length}. If \code{NULL}, then it will use
\code{width(rowRanges(rse))} which should be used for exon RSEs.}

\item{mapped_var}{A length 1 character vector with the column name from
\code{colData(rse)} that has the number of reads mapped. For recount RSE
object this would be \code{mapped_read_count}. If \code{NULL} (default)
then it will use the column sums of the counts matrix. The results are
different because not all mapped reads are mapped to exonic segments of the
genome.}
}
\value{
A matrix with the RPKM values.
}
\description{
For some analyses you might be interested in transforming the counts into
RPKMs which you can do with this function.
}
\details{
For gene RSE objects, you will want to specify the \code{length_var}
because otherwise you will be adjusting for the total gene length instead
of the total exonic sequence length of the gene.
}
\examples{

## get RPKM matrix
rpkm <- getRPKM(rse_gene_SRP009615)

## You can also get an RPKM matrix after running scale_counts()
## with similar RPKM values
rpkm2 <- getRPKM(scale_counts(rse_gene_SRP009615))
rpkm3 <- getRPKM(scale_counts(rse_gene_SRP009615, by = "mapped_reads"))

summary(rpkm - rpkm2)
summary(rpkm - rpkm3)
summary(rpkm2 - rpkm3)
}
\seealso{
\link{scale_counts}
}
\author{
Andrew Jaffe, Leonardo Collado-Torres
}
