% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMedSenLineActivity.R
\name{getMedSenLineActivity}
\alias{getMedSenLineActivity}
\title{Returns a vector of median sensitive cell line activity (-logGI50) values
for a set of compounds.}
\usage{
getMedSenLineActivity(
  idSet,
  senLineActZThreshold = 0.5,
  onlyCellMinerExps = TRUE,
  dataSource = "NCI60"
)
}
\arguments{
\item{idSet}{a character vector specifying identifier(s) for compound(s) of interest.}

\item{senLineActZThreshold}{the minimum activity z-score for a sensitive cell line (default=0.5).}

\item{onlyCellMinerExps}{a logical value indicating whether to base results strictly on
experimental data included in CellMiner (default=TRUE).}

\item{dataSource}{character string indicating data source (default="NCI60"). 
Currently only "NCI60" is supported.}
}
\value{
a numeric vector of median sensitive cell line activity (-logGI50) values indexed 
by the identifiers in idSet.
}
\description{
Returns a vector of median sensitive cell line activity (-logGI50) values
for a set of compounds.
}
\examples{
idSet <- c("609699", "740")
getMedSenLineActivity(idSet)

}
\concept{rcellminer}
