% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDocumentation.R
\docType{data}
\name{drugDB}
\alias{drugDB}
\title{CellMiner Drug Response Values}
\description{
CellMiner Drug Response Values
}
\details{
A list containing response values and annotations: 
\itemize{
 \item{act} {Z-scores of the averaged negative log GI (growth inhibition) 50 values across repeats
    for the NCI-60; assay described here: \url{http://dtp.nci.nih.gov/branches/btb/ivclsp.html }}
 \item{annot} { 
   \itemize{
     \item{id} {Dataset identifier; NOTE: DO NOT use this column; the NSC is 
       the primary drug identifier}
     \item{nsc} {National Service Center identifier; the primary drug identifier}
     \item{name} {Compound name}
     \item{brand_name} {Brand name for the compound, if sold commericially}
     \item{formula} {Compound chemical formula}
     \item{testing_status} {Information on whether it is known if the 
       compound is FDA approved or undergoing testing in clinical trials}
     \item{source} {TODO} 
     \item{smiles} {Compound chemical structure as a SMILES string} 
     \item{weight} {Compound chemical weight in g/mol} 
     \item{mechanism} {Pharmacological mechanism of action} 
     \item{confidential_flag} {A flag to indicate if compound information is public} 
     \item{total_probes} {TODO} 
     \item{total_good_probes} {TODO} 
     \item{low_correlations} {TODO} 
     \item{failure_reason} {TODO} 
     \item{cas} {CAS Registry Number; NOTE: Due to data restrictions PubChem IDs 
       are the preferred mapping ID to other datasets} 
     \item{pubchem_id} {PubChem ID}
 	 }
  }
}
}
\references{
\url{http://discover.nci.nih.gov/cellminer/loadDownload.do}
}
\author{
Vinodh Rajapakse \email{vinodh.rajapakse AT nih.gov}
}
\concept{rcellminer}
\keyword{data}
