% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawDiag.R
\name{plotInjectionTime}
\alias{plotInjectionTime}
\alias{PlotInjectionTime}
\title{Plot Injection Time}
\usage{
plotInjectionTime(x, method = "trellis")
}
\arguments{
\item{x}{a \code{data.frame} object adhering to the specified criteria for
the \code{is.rawDiag} function.}

\item{method}{specifying the plot method 'trellis' | 'violin' | 'overlay'.
The default is 'trellis'.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
shows the injection time density of each mass spectrometry file as a violin
plot. The higher the maximum number of MS2 scans is in the method,
the more the density is shifted towards the maximum injection time value.
}
\examples{
rawrr::sampleFilePath() |> rawDiag::readRaw() |> rawDiag::plotInjectionTime()
}
\references{
\itemize{
\item rawDiag: \doi{10.1021/acs.jproteome.8b00173},
\item rawrr: \doi{10.1021/acs.jproteome.0c00866}
}
}
\author{
Christian Trachsel (2017), Christian Panse (2023)
}
