% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc-pileup.R
\name{read_sparray}
\alias{read_sparray}
\title{Read sparseMatrix produced by pileup_cells()}
\usage{
read_sparray(mtx_fn, sites_fn, bc_fn, site_format = c("coordinate", "index"))
}
\arguments{
\item{mtx_fn}{.mtx.gz file path}

\item{sites_fn}{sites.txt.gz file path}

\item{bc_fn}{bcs.txt.gz file path}

\item{site_format}{one of \code{coordinate} or \code{index}, \code{coordinate} will populate
a SingleCellExperiment with rowRanges and rownames corresponing to genomic
intervals, whereas `index`` will only add row indices to the rownames.}
}
\value{
a \code{SingleCellExperiment} object populated with \code{nRef} and \code{nAlt}
assays.
}
\description{
Read in tables produced by \code{pileup_cells()} which are an
extension of the matrixMarket sparse matrix format to store values for more
than 1 matrix.

The .mtx.gz files are formatted with columns:
\enumerate{
\item row index (0 based)
\item column index (0 based)
\item values for sparseMatrix #1 (nRef)
\item values for sparseMatrix #2 (nAlt)
}
}
\examples{
library(Rsamtools)
library(GenomicRanges)
bam_fn <- raer_example("5k_neuron_mouse_possort.bam")

gr <- GRanges(c("2:579:-", "2:625:-", "2:645:-", "2:589:-", "2:601:-"))
gr$REF <- c(rep("A", 4), "T")
gr$ALT <- c(rep("G", 4), "C")

cbs <- unique(scanBam(bam_fn, param = ScanBamParam(tag = "CB"))[[1]]$tag$CB)
cbs <- na.omit(cbs)

outdir <- tempdir()
bai <- indexBam(bam_fn)

fp <- FilterParam(library_type = "fr-second-strand")
mtx_fns <- pileup_cells(bam_fn, gr, cbs, outdir, return_sce = FALSE)
sce <- read_sparray(mtx_fns[1], mtx_fns[2], mtx_fns[3])
sce

unlink(bai)

}
