% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy.R
\name{accuracy}
\alias{accuracy}
\alias{confusionTable}
\title{Calculate Classification Accuracy}
\usage{
accuracy(actual, predicted, rank)

confusionTable(actual, predicted, rank)
}
\arguments{
\item{actual}{data.frame with the actual classification hierarchy.}

\item{predicted}{data.frame with the predicted classification hierarchy.}

\item{rank}{rank at which the accuracy should be evaluated.}
}
\value{
The accuracy or a confusion table.
}
\description{
Calculate the classification accuracy at a given phylogenetic level.
}
\examples{

seq <- readRNAStringSet(system.file("examples/RNA_example.fasta",
    package = "rRDP"
))

### decode the actual classification
actual <- decode_Greengenes(names(seq))

### use RDP to predict the classification
pred <- predict(rdp(), seq)

### calculate accuracy
confusionTable(actual, pred, "genus")
accuracy(actual, pred, "genus")
}
\keyword{model}
