/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;

public class CopyNumberParser {
    public HashMap<String, TaxonCopyNumber> parse(String cnFile) throws IOException {
        HashMap<String, TaxonCopyNumber> cnMap = new HashMap<String, TaxonCopyNumber>();
        BufferedReader reader = new BufferedReader(new FileReader(cnFile));
        String line = reader.readLine();
        String[] header = line.split("\t");
        int rankcol = -1;
        int namecol = -1;
        int meancol = -1;
        for (int i = 0; i < header.length; ++i) {
            if (header[i].equalsIgnoreCase("name")) {
                namecol = i;
                continue;
            }
            if (header[i].equalsIgnoreCase("rank")) {
                rankcol = i;
                continue;
            }
            if (!header[i].equalsIgnoreCase("mean")) continue;
            meancol = i;
        }
        if (rankcol < 0 || namecol < 0 || meancol < 0) {
            throw new IllegalArgumentException("The header line of the copynumber file " + cnFile + " does not have rank, name or mean headers");
        }
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0) continue;
            String[] val = line.split("\t");
            String key = (val[namecol] + val[rankcol]).toLowerCase();
            if (cnMap.get(key) != null) {
                throw new IllegalArgumentException("Duplicate taxon " + val[namecol] + " " + val[rankcol] + " found in the copynumber file " + cnFile);
            }
            TaxonCopyNumber cn = new TaxonCopyNumber(val[namecol], val[rankcol], Float.parseFloat(val[meancol]));
            cnMap.put(key, cn);
        }
        return cnMap;
    }

    public class TaxonCopyNumber {
        String name;
        String rank;
        float meanCopyNumber;

        public TaxonCopyNumber(String n, String r, float c) {
            this.name = n;
            this.rank = r;
            this.meanCopyNumber = c;
        }

        public String getName() {
            return this.name;
        }

        public String getRank() {
            return this.rank;
        }

        public float getCopyNumber() {
            return this.meanCopyNumber;
        }
    }
}

