% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{track_scalebar}
\alias{track_scalebar}
\title{Generate scalebar track}
\usage{
track_scalebar(
  title = NULL,
  height = 2,
  overlay_previous = "no",
  where = "left",
  fontsize = 12,
  line_width = 0.5,
  color = "black",
  alpha = 1,
  x_center = NULL,
  size = NULL,
  scalebar_start_position = NULL,
  scalebar_end_position = NULL
)
}
\arguments{
\item{title}{String. If specificed, the title of the track to be displayed.}

\item{height}{Numeric. The height of the plotted track in cm. Default is 2.
See notes.}

\item{overlay_previous}{String. Options are "no" (default) or "yes" or
"share-y".}

\item{where}{"left" (default), "right", "top" or "bottom".}

\item{fontsize}{Numeric value to font size of tracks's text.}

\item{line_width}{0.5 (default) or any float above 0.}

\item{color}{String. Hex color or string color. Default is "#1f78b4".}

\item{alpha}{Numeric variable between 0 and 1 to indicate level of transparancy.
Default is 1.}

\item{x_center}{Numeric value above 0. Default is NULL.}

\item{size}{Numeric value above 0. Default is NULL.}

\item{scalebar_start_position}{Numeric value above 0. Default is NULL.}

\item{scalebar_end_position}{Numeric value above 0. Default is NULL.}
}
\value{
genome_track
}
\description{
scalebar track is a track with a stretch that highlights
specific distance on the genomic coordiantes
}
\note{
\code{fontsize} argument can be overriden by the same argument in \code{plot_gtracks()}
}
\examples{
np_bed_dir <- system.file("extdata", "test2.narrowPeak", package = "rGenomeTracks")

tracks <-
  track_scalebar(
    scalebar_start_position = 2785 * 10^3,
    scalebar_end_position = 2799 * 10^3
  ) +
  track_narrow_peak(np_bed_dir,
    title = "peak type with summit",
    height = 3,
    type = "peak",
    color = "green"
  ) + track_x_axis()
\dontrun{
plot_gtracks(tracks, chr = "X", start = 276 * 10^4, end = 280 * 10^4, trackLabelFraction = 0.2)
}
}
\author{
Omar Elashkar
}
