% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{track_domains}
\alias{track_domains}
\title{Generate domains track}
\usage{
track_domains(
  file,
  title = NULL,
  height = 2,
  overlay_previous = "no",
  orientation = NULL,
  line_width = 0.5,
  color = "#1f78b4",
  max_value = NULL,
  show_data_range = TRUE,
  min_value = NULL,
  border_color = "black",
  prefered_name = "transcript_name",
  merge_transcripts = FALSE
)
}
\arguments{
\item{file}{String. The location of the track file}

\item{title}{String. If specificed, the title of the track to be displayed.}

\item{height}{Numeric. The height of the plotted track in cm. Default is 2.
See notes.}

\item{overlay_previous}{String. Options are "no" (default) or "yes" or
"share-y".}

\item{orientation}{String. Set to "inverted" to make the track upside down.
Default is NULL.}

\item{line_width}{Numeric. Default is 0.5.}

\item{color}{String. Hex color or string color. Default is "#1f78b4".}

\item{max_value}{Numeric. Default is NULL. The max value cut-off for the
numeric column.}

\item{show_data_range}{Boolean. Default is TRUE.}

\item{min_value}{Numeric. Default is NULL. The max value cut-off for the
numeric column.}

\item{border_color}{String. default is "black"}

\item{prefered_name}{String. Denote which column to get elements names.
Default is "transcript_name".}

\item{merge_transcripts}{Boolean. Default is FALSE.}
}
\value{
genome_track
}
\description{
Domain files are bed files represents TADS in the case of HiC analysis.
}
\details{
To remove the border, set 'border_color' parameter to "none".
}
\examples{
tads_dir <- system.file("extdata", "tad_classification.bed",
  package = "rGenomeTracks"
)
tads <- track_domains(
  file = tads_dir, border_color = "black",
  color = "#11FF34", height = 5
)
tads_i <- track_domains(
  file = tads_dir, border_color = "red",
  color = "#cccccc", height = 3, orientation = "inverted"
)
tracks <- track_x_axis(where = "top") +
  tads + tads_i
\dontrun{
plot_gtracks(tracks, chr = "X", start = 30 * 10^5, end = 35 * 10^5)
}
}
\author{
Omar Elashkar
}
