% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{track_bigwig}
\alias{track_bigwig}
\title{Generate bigwig track}
\usage{
track_bigwig(
  file,
  title = NULL,
  height = 2,
  overlay_previous = "no",
  orientation = NULL,
  color = "#1f78b4",
  alpha = 1,
  max_value = NULL,
  min_value = NULL,
  show_data_range = TRUE,
  type = "fill",
  negative_color = NULL,
  nans_to_zeros = FALSE,
  summary_method = "mean",
  number_of_bins = 700,
  transform = "no",
  log_pseudocount = 0,
  y_axis_values = "transformed",
  second_file = NULL,
  operation = "file",
  grid = FALSE
)
}
\arguments{
\item{file}{String. The location of the track file}

\item{title}{String. If specificed, the title of the track to be displayed.}

\item{height}{Numeric. The height of the plotted track in cm.}

\item{overlay_previous}{String. Options are "no" (default) or "yes" or}

\item{orientation}{String. Set to "inverted" to make the track upside down. Default is NULL.}

\item{color}{String. Hex color or string color. Default is "#1f78b4".}

\item{alpha}{Numeric variable between 0 and 1 to indicate level of transparancy.
Default is 1.}

\item{max_value}{Numeric. Default is NULL.
The max value cut-off for the numeric column.}

\item{min_value}{Numeric. Default is NULL.
The max value cut-off for the numeric column.}

\item{show_data_range}{Boolean. Default is TRUE.}

\item{type}{String. Options are "fill" (default),"line", "points".}

\item{negative_color}{Hex color or string to indicate color of negative values. Default is NULL.}

\item{nans_to_zeros}{Boolean. To convert empty values to zeros,
set this to TRUE. Default is FALSE.}

\item{summary_method}{String. summary_method applied over bin range.
This parameter is set to NULL. See details for options.}

\item{number_of_bins}{Numeric value to indicate summary method used over the bin range. Default is 700}

\item{transform}{String to indicate type of transformation applied.
Default is "no".}

\item{log_pseudocount}{Numeric. Default is 0.}

\item{y_axis_values}{String with two options "transformed" (default) or "original".}

\item{second_file}{Path for another file to be included in operations.
This parameter is not set by default.}

\item{operation}{Default is set to "file". See details.}

\item{grid}{Boolean. Default is FALSE.}
}
\value{
None
}
\description{
Create genome_track object from bigwig file.
}
\details{
summary_method parameter can be choosen to be by "mean", "average", "max",
"min", "stdev", "dev", "coverage", "cov" or "sum".
Tranform paramter options are "no" (default) or "log", "log1p", "-log", "log2" or "log10".
'log1p': transformed_values = log(1 + initial_values)
'log': transformed_values = log(log_pseudocount + initial_values)
'log2': transformed_values = log2(log_pseudocount + initial_values)
'log10': transformed_values = log10(log_pseudocount + initial_values)
'-log': transformed_values = log(log_pseudocount + initial_values)
To compute operations on the fly on the file or between 2 bedgraph files,
you can tweak operation parameter, it should contains file or
file and second_file. It is adviced to use \code{nans_to_zeros = TRUE} to
avoid unexpected results. Example value for operation are "0.89 * file",
"- file", "file - second_file", "log2((1 + file) / (1 + second_file))" and
"max(file, second_file)"
}
\section{to add the preferred line width or point size : type = "line:lw" where lw (linewidth) is numeric value.}{
Like \code{type = "line:0.5"} and \code{type = "points:0.5"}
}

\examples{
bw_dir <- system.file("extdata", "bigwig2_X_2.5e6_3.5e6.bw",
  package = "rGenomeTracks"
)
mean_bw <- track_bigwig(
  file = bw_dir, color = "gray",
  type = "point:1", summary_method = "mean", number_of_bins = 300, max_value = 200, min_value = -5
)
min_bw <- track_bigwig(
  file = bw_dir, color = "blue", type = "line:1", summary_method = "min", number_of_bins = 300,
  overlay_previous = "share-y", show_data_range = FALSE,
  max_value = 200, min_value = -5
)
max_bw <- track_bigwig(
  file = bw_dir, color = "red", type = "line:1", summary_method = "max", number_of_bins = 300,
  overlay_previous = "share-y", show_data_range = FALSE,
  max_value = 200, min_value = -5
)
hlines <- track_hlines(
  y_values = "10, 150",
  overlay_previous = "share-y",
  color = "blue", line_style = "dotted"
)
\dontrun{
plot_gtracks(mean_bw + min_bw + max_bw + hlines, chr = "X", start = 27 * 10^5, end = 31 * 10^5)
}
}
\author{
Omar Elashkar
}
