% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_transcripts.R
\name{select_transcripts}
\alias{select_transcripts}
\title{Select transcripts associated with degradation}
\usage{
select_transcripts(top_n = 1000, cell_component = FALSE)
}
\arguments{
\item{top_n}{An \code{integer(1)} specifying how many significant transcripts to
extract from each model prior to taking a union across models.}

\item{cell_component}{A \code{logical(1)}. If \code{FALSE}, only include transcripts
from the main and interaction models (see \code{main_model} and \code{int_model}
here: \link{transcripts}). If \code{TRUE}, additionally include main and
interaction models that include cell-type proportions (a total of 4 models).}
}
\value{
A \code{character()} with the transcript IDs.
}
\description{
Helper function to select which experimental model(s) will be used to
generate the qSVs. Degradation-associated transcripts are derived in four
different models (\link{transcripts}). The \code{cell_component} parameter
controls whether the models with cell-type proportions are included. This
function extract the top \code{top_n} transcripts found to be significant in
each considered model, then returns the union of transcripts across all
considered models. Up to 10,000 transcripts are available to select from
each model prior to taking the union.
}
\examples{
## Default set of transcripts associated with degradation
sig_transcripts <- select_transcripts()
length(sig_transcripts)
head(sig_transcripts)

## Select more transcripts if desired
length(select_transcripts(top_n = 5000))
}
