% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBox.R
\name{plotBox}
\alias{plotBox}
\title{Box plot}
\usage{
plotBox(x, i, group, log2 = FALSE, violin = FALSE, ylab = "Intensity")
}
\arguments{
\item{x}{A matrix-like object or \linkS4class{SummarizedExperiment} object.}

\item{i}{A string or integer value specifying which assay values to use
when \code{x} is a SummarizedExperiment object.}

\item{group}{A discrete variable to visualize the grouping structure.}

\item{log2}{A logical specifying whether feature intensities needs to be
log2-transformed before visualization.}

\item{violin}{A logical specifying whether a violin plot is shown instead of
a boxplot.}

\item{ylab}{A string specifying the title of y-axis.}
}
\value{
A ggplot object.
}
\description{
Produces a box-and-whisker plot with a \linkS4class{SummarizedExperiment} or
matrix-like object where rows represent features and columns represent
samples.
}
\examples{

data(faahko_se)

## Sample group
g <- colData(faahko_se)$sample_group

## SummarizedExperiment object
plotBox(faahko_se, i = "knn", group = g, log2 = TRUE) # before normalization

## Matrix
m <- assay(faahko_se, "knn_vsn")
plotBox(m, group = g) # after normalization

}
