% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Raw_Methods.R, R/SetMethods.R
\name{plotCalib}
\alias{plotCalib}
\alias{plotCalib,ptrRaw-method}
\alias{plotCalib,ptrSet-method}
\title{Plot the calibration peaks after calibration}
\usage{
plotCalib(object, ppm = 2000, ...)

\S4method{plotCalib}{ptrRaw}(object, ppm = 2000, ...)

\S4method{plotCalib}{ptrSet}(object, ppm = 2000, pdfFile = NULL, fileNames = NULL, ...)
}
\arguments{
\item{object}{a ptrSet or ptrRaw object}

\item{ppm}{the width of plot windows}

\item{...}{not used}

\item{pdfFile}{is different of \code{NULL}, the file path to save the 
plots in pdf}

\item{fileNames}{the name of the files in the ptrSet object to plot. 
If \code{NULL}, all files will be
plotted}
}
\value{
plot
}
\description{
Plot the calibration peaks after calibration
}
\examples{
## ptrSet
dirRaw <- system.file("extdata/exhaledAir", package = "ptairData")
exhaledPtrset <- createPtrSet(dir=dirRaw, setName="exhaledPtrset", 
mzCalibRef = c(21.022, 60.0525), fracMaxTIC = 0.7, saveDir = NULL )
plotCalib(exhaledPtrset ,fileNames=getFileNames(exhaledPtrset )[1])

## ptrRaw 
filePath<-system.file('extdata/exhaledAir/ind1/ind1-1.h5', 
package = 'ptairData')
raw <- readRaw(filePath,mzCalibRef=c(21.022,59.049))
plotCalib(raw)
}
