% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Raw_Methods.R, R/SetMethods.R
\name{defineKnots}
\alias{defineKnots}
\alias{defineKnots,ptrRaw-method}
\alias{defineKnots,ptrSet-method}
\title{Define the knots location}
\usage{
defineKnots(
  object,
  knotsPeriod = 3,
  method = c("expiration", "uniform", "manual")[1],
  knotsList = NULL,
  ...
)

\S4method{defineKnots}{ptrRaw}(
  object,
  knotsPeriod = 3,
  method = c("expiration", "uniform")[1],
  knotsList = NULL,
  timeLimit = list(NULL)
)

\S4method{defineKnots}{ptrSet}(
  object,
  knotsPeriod = 3,
  method = c("expiration", "uniform")[1],
  knotsList = NULL
)
}
\arguments{
\item{object}{ptrSet object}

\item{knotsPeriod}{the period in second (times scale) between two knots for 
the two dimensional modelization}

\item{method}{expiration or uniform}

\item{knotsList}{a list of knot location for each files, with all base name 
file in name of the list element}

\item{...}{not used}

\item{timeLimit}{index time of the expiration limits and background}
}
\value{
numeric vector of knots

a list with numeric vector of knots for each file
}
\description{
\code{defineKnots} function determine the knots location for a ptrSet or 
ptrRaw object.
There is three possibilities :  
\itemize{
\item \code{method = expiration} in the expiration periods, a knots is 
placed every \code{knotsPeriod} seconds, and 1 knots in the middle of two 
expiration, one at begin and at the end
\item \code{method= uniforme}, the knots are placed uniformly every 
\code{knotsPeriod} time points
\item give in \code{knotsList} a list of knot, with all base name file in 
name of the list element.  All file must be informed. The knots location 
must be contained in the time axis
}
}
\examples{
library(ptairData)
dirRaw <- system.file("extdata/exhaledAir", package = "ptairData")
exhaledPtrset <- createPtrSet(dir=dirRaw, setName="exhaledPtrset", 
mzCalibRef = c(21.022, 60.0525), fracMaxTIC = 0.7, saveDir = NULL )

#### placed knots every 2 times points
exhaledPtrset <- defineKnots(exhaledPtrset ,knotsPeriod=2,method='uniform')

#### placed knots every 3 times points in the expiration (default)
exhaledPtrset <- defineKnots(exhaledPtrset ,knotsPeriod=3,method='expiration')
}
