% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_dimReduction.R
\name{reduceDimensionality}
\alias{reduceDimensionality}
\title{Reduce dimensionality after processing missing values from data frame}
\usage{
reduceDimensionality(
  data,
  type = c("pca", "ica"),
  center = TRUE,
  scale. = FALSE,
  naTolerance = NULL,
  missingValues = round(0.05 * ncol(data)),
  ...
)
}
\arguments{
\item{data}{Data frame: data}

\item{type}{Character: dimensionality reduction technique (\code{pca} or
\code{ica})}

\item{center}{either a logical value or numeric-alike vector of length
    equal to the number of columns of \code{x}, where
    \sQuote{numeric-alike} means that \code{\link[base]{as.numeric}(.)} will
    be applied successfully if \code{\link[base]{is.numeric}(.)} is not true.}

\item{scale.}{Boolean: scale variables?}

\item{naTolerance}{Integer: percentage of tolerated missing values per column
(deprecated)}

\item{missingValues}{Integer: number of tolerated missing values per column
to be replaced with the mean of the values of that same column}

\item{...}{Extra parameters passed to FUN}
}
\value{
PCA result in a \code{prcomp} object or ICA result
object
}
\description{
Reduce dimensionality after processing missing values from data frame
}
\keyword{internal}
