% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_fileBrowserDialog.R
\name{fileBrowser}
\alias{fileBrowser}
\title{Interactive folder selection using a native dialogue}
\source{
\url{https://github.com/wleepang/shiny-directory-input}
}
\usage{
fileBrowser(
  default = NULL,
  caption = NULL,
  multiple = FALSE,
  directory = FALSE
)
}
\arguments{
\item{default}{Character: path to initial folder}

\item{caption}{Character: caption on the selection dialogue}

\item{multiple}{Boolean: allow to select multiple files?}

\item{directory}{Boolean: allow to select directories instead of files?}
}
\value{
A length one character vector, character NA if 'Cancel' was selected
}
\description{
Interactive folder selection using a native dialogue
}
\details{
Platform-dependent implementation:
\itemize{
 \item{\strong{Windows}: calls the \code{utils::choose.files} R function.}
 \item{\strong{macOS}: uses AppleScript to display a folder selection
 dialogue. If \code{default = NA}, folder selection falls back to the
 default behaviour of the \code{choose folder} AppleScript command.
 Otherwise, paths are expanded with \code{\link{path.expand}()}.}
 \item{\strong{Linux}: calls the \code{zenity} system command.}
}
}
\keyword{internal}
