% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/cluster2pattern.R
\docType{methods}
\name{cluster2pattern}
\alias{cluster2pattern}
\alias{cluster2pattern,character-method}
\alias{cluster2pattern,numeric-method}
\alias{cluster2pattern,kmeans-method}
\alias{cluster2pattern,hclust-method}
\title{Generic cluster2pattern function}
\usage{
cluster2pattern(clusters, NP, data, ...)

\S4method{cluster2pattern}{character}(clusters, data)

\S4method{cluster2pattern}{numeric}(clusters, data)

\S4method{cluster2pattern}{kmeans}(clusters, data)

\S4method{cluster2pattern}{hclust}(clusters, NP, data = NA)
}
\arguments{
\item{clusters}{a cluster object which could be either an hclust or a kmeans object}

\item{NP}{number of desired patterns}

\item{data}{data used to make clusters object}

\item{...}{Additional arguments to cluster2pattern}
}
\value{
An object of class pclust containing pattern weights corresponding for each cluster.
}
\description{
Function to make patterns of continuous weights from clusters.
}
\examples{
k.RNAseq6l3c3t<-kmeans(t(p.RNAseq6l3c3t),3)
cluster2pattern(clusters=k.RNAseq6l3c3t,data=p.RNAseq6l3c3t)

distp <- dist(t(p.RNAseq6l3c3t))
hc.RNAseq6l3c3t <- hclust(distp)
cluster2pattern(clusters=hc.RNAseq6l3c3t,NP=3,data=p.RNAseq6l3c3t)
}
