% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/junction-read-count.R
\name{calculatePromoterReadCounts}
\alias{calculatePromoterReadCounts}
\title{Calculate the promoter read counts using junction read counts approach for
all the input junction files}
\usage{
calculatePromoterReadCounts(
  promoterAnnotation,
  files = NULL,
  fileLabels = NULL,
  fileType = NULL,
  genome = NULL,
  numberOfCores = 1
)
}
\arguments{
\item{promoterAnnotation}{A PromoterAnnotation object containing the
reduced exon ranges, annotated intron ranges, promoter coordinates and the
promoter id mapping}

\item{files}{A character vector. The list of junction or BAM files 
for which the junction read counts will be calculated}

\item{fileLabels}{A character vector. The labels of junction or BAM 
files for which the junction read counts will be calculated. These labels 
will be used as column names for the output data.frame object}

\item{fileType}{A character. Type of the junction bed or bam file, either
'tophat', 'star' or 'bam}

\item{genome}{A character. Genome version used. Must be specified if input is
a BAM file. Defaults to NULL}

\item{numberOfCores}{A numeric value. The number of cores to be used for
counting junction reads. Defaults to 1 (no parallelization). This parameter
will be used as an argument to BiocParallel::bplapply}
}
\value{
A data.frame object. The number of junction reads per promoter (rows)
  for each sample (cols)
}
\description{
Calculate the promoter read counts using junction read counts approach for
all the input junction files
}
