% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-proActiv.R
\name{boxplotPromoters}
\alias{boxplotPromoters}
\title{Visualizes promoter activity and gene expression with boxplots}
\usage{
boxplotPromoters(
  result,
  geneId,
  geneName = NULL,
  filterInternal = TRUE,
  col = NULL
)
}
\arguments{
\item{result}{A SummarizedExperiment object return by proActiv, with assays 
giving promoter counts and activity with gene expression stored as 
metadata. rowData contains promoter metadata and absolute promoter 
activity summarized across conditions. Condition must be provided.}

\item{geneId}{A character vector. A single gene id. This identifier must
correspond to the identifier in the promoter annotation.}

\item{geneName}{A character vector. Common gene name to be displayed
on plot. Optional. Defaults to NULL.}

\item{filterInternal}{A boolean. Determines if internal promoters should be 
removed from the plot. Defaults to TRUE.}

\item{col}{A character vector of colours to be used for plotting.}
}
\value{
A list of length 3. Each entry is a plot corresponding to 
 absolute promoter activity, relative promoter activity and gene expression.
}
\description{
Visualizes promoter activity and gene expression with boxplots
}
\examples{
files <- list.files(system.file('extdata/vignette/junctions', 
                       package = 'proActiv'), 
                       full.names = TRUE, pattern = 'replicate5')
promoterAnnotation <- promoterAnnotation.gencode.v34.subset
result <- proActiv(files = files,
                       promoterAnnotation  = promoterAnnotation,
                       condition = rep(c('A549', 'HepG2'), each=1),
                       fileLabels = NULL,
                       ncores = 1)
plots <- boxplotPromoters(result, "ENSG00000076864.19")

}
