% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_samples_by_mv}
\alias{filter_samples_by_mv}
\title{Filter samples by missing values}
\usage{
filter_samples_by_mv(df, max_perc_mv, classes = NULL, remove_samples = TRUE)
}
\arguments{
\item{df}{A matrix-like (e.g. an ordinary matrix, a data frame) or 
\link[SummarizedExperiment]{RangedSummarizedExperiment-class} object with 
all values of class \code{numeric()} or \code{integer()} of peak 
intensities, areas or other quantitative characteristic.}

\item{max_perc_mv}{\code{numeric(1)}, Value between 0 and 1 of threshold 
of missing value percentage in sample.}

\item{classes}{\code{character()}, vector of class labels. Must be the same 
length as the number of sample in the input peak table. If input is 
\code{SummarizedExperiment} object, use 
\code{SummarizedExperiment_object$meta_data_column_name}.}

\item{remove_samples}{\code{logical(1)}, remove blank samples from peak 
matrix or not.}
}
\value{
Object of class \code{SummarizedExperiment}. If input data are a 
matrix-like (e.g. an ordinary matrix, a data frame) object, function returns 
\code{numeric()} matrix-like object of filtered data set. Function 
\code{flags} are added to the object \code{attributes} and is a 
\link[S4Vectors]{DataFrame-class} with five columns. The same 
\code{DataFrame} object containing flags is added to \code{rowData()} 
element of \code{SummarizedExperiment} object as well. If element 
\code{colData()} already exists flags are appended to existing values.\cr
\cr

Columns in \code{colData()} or \code{flags} element contain: \cr
\code{perc_mv} \code{numeric()}, fraction of missing values per sample; \cr
\code{flags} \code{integer()},if 0 feature is flagged to be removed. \cr
}
\description{
Missing values in mass spectrometry metabolomic datasets occur widely and 
can originate from a number of sources, including for both technical and 
biological reasons. In order for robust conclusions to be drawn from 
down-stream statistical testing procedures, the issue of missing values 
must first be addressed. This tool facilitates the removal of samples 
containing a user-defined maximum percentage of missing values.
}
\examples{

df <- MTBLS79
out <- filter_samples_by_mv (df=df, max_perc_mv=0.8)

}
