% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTranscripts.R
\name{plotTranscripts}
\alias{plotTranscripts}
\title{Plot gene transcripts in a pileup style for a single chromosome}
\usage{
plotTranscripts(
    chrom,
    chromstart = NULL,
    chromend = NULL,
    assembly = "hg38",
    fill = c("#669fd9", "#abcc8e"),
    colorbyStrand = TRUE,
    strandSplit = FALSE,
    boxHeight = unit(2, "mm"),
    spaceWidth = 0.02,
    spaceHeight = 0.3,
    limitLabel = TRUE,
    transcriptHighlights = NULL,
    transcriptFilter = NULL,
    fontsize = 8,
    labels = "transcript",
    stroke = 0.1,
    bg = NA,
    x = NULL,
    y = NULL,
    width = NULL,
    height = NULL,
    just = c("left", "top"),
    default.units = "inches",
    draw = TRUE,
    params = NULL
)
}
\arguments{
\item{chrom}{Chromosome of region to be plotted, as a string.}

\item{chromstart}{Integer start position on chromosome to be plotted.}

\item{chromend}{Integer end position on chromosome to be plotted.}

\item{assembly}{Default genome assembly as a string or a
\link[plotgardener]{assembly} object.
Default value is \code{assembly = "hg38"}.}

\item{fill}{Character value(s) as a single value or vector
specifying fill colors of transcripts.
Default value is \code{fill = c("#669fd9", "#abcc8e")}.}

\item{colorbyStrand}{A logical value indicating whether to
color plus and minus strands by the first two colors in
a \code{fill} vector, where plus strand transcripts will be
colored by the first \code{fill} color and
minus strand transcripts will be colored by the second \code{fill}
color. Default value is \code{colorbyStrand = TRUE}.}

\item{strandSplit}{A logical value indicating whether plus and
minus-stranded transcripts should be separated, with plus strand
transcripts plotted above the x-axis and minus strand transcripts
plotted below the x-axis. Default value is \code{strandSplit = FALSE}.}

\item{boxHeight}{A numeric or unit object specifying height of transcripts.
Default value is \code{boxHeight = unit(2, "mm")}.}

\item{spaceWidth}{A numeric value specifying the width of minimum spacing
between transcripts, as a fraction of the plot's genomic range.
Default value is \code{spaceWidth = 0.02}.}

\item{spaceHeight}{A numeric value specifying the height of spacing
between transcripts on different rows, as a fraction of \code{boxHeight}.
Default value is \code{spaceHeight = 0.3}.}

\item{limitLabel}{A logical value indicating whether to draw a "+"
when not all elements can be plotted in the plotting space. Default 
value is \code{limitLabel = TRUE}.}

\item{transcriptHighlights}{A two-column dataframe with a column named
"transcript" or "gene" containing transcript names or their associated gene 
names as strings to highlight and a column named "color" containing 
corresponding highlight colors.}

\item{transcriptFilter}{A character vector of the names of transcripts to 
display (default is \code{NULL}, no filtering)}

\item{fontsize}{A numeric specifying text fontsize in points.
Default value is \code{fontsize = 8}.}

\item{labels}{A character value describing the format of
transcript text labels. Default value is \code{labels = "trancript"}.
Options are:
\itemize{
\item{\code{NULL}: }{No labels.}
\item{\code{"transcript"}: }{Transcript name labels.}
\item{\code{"gene"}: }{Gene name labels.}
\item{\code{"both"}: }{Combined transcript and gene name labels with
the format "gene name:transcript name".}
}}

\item{stroke}{A numeric value indicating the stroke width for
transcript body outlines. Default value is \code{stroke = 0.1}.}

\item{bg}{Character value indicating background color.
Default value is \code{bg = NA}.}

\item{x}{A numeric or unit object specifying transcript plot x-location.}

\item{y}{A numeric, unit object, or character containing a "b"
combined with a numeric value specifying transcript plot y-location.
The character value will
place the transcript plot y relative to the bottom of the most recently
plotted plot according to the units of the plotgardener page.}

\item{width}{A numeric or unit object specifying transcript plot width.}

\item{height}{A numeric or unit object specifying transcript plot height.}

\item{just}{Justification of transcript plot relative to
its (x, y) location. If there are two values, the first value specifies
horizontal justification and the second value specifies vertical
justification.
Possible string values are: \code{"left"}, \code{"right"},
\code{"centre"}, \code{"center"}, \code{"bottom"}, and \code{"top"}.
Default value is \code{just = c("left", "top")}.}

\item{default.units}{A string indicating the default units to use if
\code{x}, \code{y}, \code{width}, or \code{height} are only given as
numerics. Default value is \code{default.units = "inches"}.}

\item{draw}{A logical value indicating whether graphics output should be
produced. Default value is \code{draw = TRUE}.}

\item{params}{An optional \link[plotgardener]{pgParams} object containing
relevant function parameters.}
}
\value{
Returns a \code{transcripts} object containing relevant
genomic region, placement, and \link[grid]{grob} information.
}
\description{
Plot gene transcripts in a pileup style for a single chromosome
}
\details{
A transcripts plot can be placed on a plotgardener coordinate page
by providing plot placement parameters:
\preformatted{
plotTranscripts(chrom, chromstart = NULL, chromend = NULL,
                x, y, width, height, just = c("left", "top"),
                default.units = "inches")
}
This function can also be used to quickly plot an unannotated
transcripts plot by ignoring plot placement parameters:
\preformatted{
plotTranscripts(chrom, chromstart = NULL, chromend = NULL)
}

Genomic annotation information is acquired through
\link[GenomicFeatures]{TxDb} and \link[AnnotationDbi]{OrgDb-class} packages,
as determined through the \code{assembly} parameter.
}
\examples{
## Load hg19 genomic annotation packages
library("TxDb.Hsapiens.UCSC.hg19.knownGene")
library("org.Hs.eg.db")

## Create page
pageCreate(width = 7.5, height = 3.5, default.units = "inches")

## Plot and place transcripts
plotTranscripts(
    chrom = "chr8", chromstart = 1000000, chromend = 2000000,
    assembly = "hg19", labels = "gene",
    x = 0.5, y = 0.5, width = 6.5, height = 2.5,
    just = c("left", "top"), default.units = "inches"
)

## Plot genome label
plotGenomeLabel(
    chrom = "chr8", chromstart = 1000000, chromend = 2000000,
    assembly = "hg19",
    x = 0.5, y = 3.03, length = 6.5, default.units = "inches"
)

## Plot a legend
plotLegend(
    legend = c("+ strand", "- strand"),
    fill = c("#669fd9", "#abcc8e"), border = FALSE,
    x = 0.5, y = 1, width = 1, height = 0.5,
    just = c("left", "top")
)

## Hide page guides
pageGuideHide()
}
\seealso{
\link[plotgardener]{assembly},
\link[plotgardener]{genomes}, \link[plotgardener]{defaultPackages}
}
