% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPairs.R
\name{plotPairs}
\alias{plotPairs}
\title{Plot paired-end genomic range elements}
\usage{
plotPairs(
    data,
    chrom,
    chromstart = NULL,
    chromend = NULL,
    assembly = "hg38",
    fill = "#1f4297",
    linecolor = NA,
    bg = NA,
    boxHeight = unit(2, "mm"),
    spaceWidth = 0.02,
    spaceHeight = 0.3,
    limitLabel = TRUE,
    baseline = FALSE,
    baseline.color = "grey",
    baseline.lwd = 1,
    x = NULL,
    y = NULL,
    width = NULL,
    height = NULL,
    just = c("left", "top"),
    default.units = "inches",
    draw = TRUE,
    params = NULL,
    ...
)
}
\arguments{
\item{data}{A string specifying the BEDPE file path, a dataframe
in BEDPE format specifying data to be plotted, or a
\link[InteractionSet]{GInteractions} object.}

\item{chrom}{Chromosome of region to be plotted, as a string.}

\item{chromstart}{Integer start position on chromosome to be plotted.}

\item{chromend}{Integer end position on chromosome to be plotted.}

\item{assembly}{Default genome assembly as a string or a
\link[plotgardener]{assembly} object.
Default value is \code{assembly = "hg38"}.}

\item{fill}{A single character value, a vector, or 
a \link[plotgardener]{colorby} object specifying fill colors of
paired range elements. Default value is \code{fill = "#1f4297"}.}

\item{linecolor}{A single character value, a vector, or a
\link[plotgardener]{colorby} object specifying the color of the lines
outlining paired range elements. Default value is \code{linecolor = NA}.
Special options include:
\itemize{
\item{\code{NA}: }{No line color.}
\item{\code{"fill"}: }{Same color as \code{fill}.}
}}

\item{bg}{Character value indicating background color.
Default value is \code{bg = NA}.}

\item{boxHeight}{A numeric or unit object specifying height of boxes
at either end of paired range elements.
Default value is \code{boxHeight = unit(2, "mm")}.}

\item{spaceWidth}{A numeric specifying the width of spacing between
paired range elements, as a fraction of the plot's genomic range.
Default value is \code{spaceWidth = 0.02}.}

\item{spaceHeight}{A numeric specifying the height of space between
boxes of paired range elements on different rows.
Default value is \code{spaceHeight = 0.3}.}

\item{limitLabel}{A logical value indicating whether to draw a "+"
when not all elements can be plotted in the plotting space. Default 
value is \code{limitLabel = TRUE}.}

\item{baseline}{Logical value indicating whether to include a baseline
along the x-axis. Default value is \code{baseline = FALSE}.}

\item{baseline.color}{Baseline color.
Default value is \code{baseline.color = "grey"}.}

\item{baseline.lwd}{Baseline line width.
Default value is \code{baseline.lwd = 1}.}

\item{x}{A numeric or unit object specifying paired range plot x-location.}

\item{y}{A numeric, unit object, or character containing a "b"
combined with a numeric value specifying paired range plot y-location.
The character value will
place the paired range plot y relative to the bottom of the most recently
plotted plot according to the units of the plotgardener page.}

\item{width}{A numeric or unit object specifying paired range plot width.}

\item{height}{A numeric or unit object specifying paired range plot height.}

\item{just}{Justification of paired range plot relative
to its (x, y) location.
If there are two values, the first value specifies horizontal
justification and the second value specifies vertical justification.
Possible string values are: \code{"left"}, \code{"right"},
\code{"centre"}, \code{"center"}, \code{"bottom"}, and \code{"top"}.
Default value is \code{just = c("left", "top")}.}

\item{default.units}{A string indicating the default units to use
if \code{x}, \code{y}, \code{width}, or \code{height} are only given
as numerics. Default value is \code{default.units = "inches"}.}

\item{draw}{A logical value indicating whether graphics
output should be produced.}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}

\item{...}{Additional grid graphical parameters. See \link[grid]{gpar}.}
}
\value{
Returns a \code{pairs} object containing relevant
genomic region, placement, and \link[grid]{grob} information.
}
\description{
Plot paired-end genomic range elements
}
\details{
#' A paired ranges plot can be placed on a plotgardener coordinate page
by providing plot placement parameters:
\preformatted{
plotPairs(data, chrom,
            chromstart = NULL, chromend = NULL,
            x, y, width, height, just = c("left", "top"),
            default.units = "inches")
}
This function can also be used to quickly plot an unannotated paired
ranges plot by ignoring plot placement parameters:
\preformatted{
plotPairs(data, chrom,
            chromstart = NULL, chromend = NULL)
}
}
\examples{
## Load paired ranges data in BEDPE format
library(plotgardenerData)
data("IMR90_DNAloops_pairs")

## Set the coordinates
params <- pgParams(
    chrom = "chr21",
    chromstart = 27900000, chromend = 30700000,
    assembly = "hg19",
    width = 7
)

## Create a page
pageCreate(width = 7.5, height = 2.1, default.units = "inches")

## Add a length column
IMR90_DNAloops_pairs$length <- 
        (IMR90_DNAloops_pairs$start2 - IMR90_DNAloops_pairs$start1) / 1000

## Plot the data
bedpePlot <- plotPairs(
    data = IMR90_DNAloops_pairs, params = params,
    fill = colorby("length", palette = 
                colorRampPalette(c("dodgerblue2", "firebrick2"))),
    lwd = 2, spaceHeight = .7,
    x = 0.25, y = 0.25, height = 1.5,
    just = c("left", "top"), default.units = "inches"
)

## Annotate genome label
annoGenomeLabel(plot = bedpePlot, x = 0.25, y = 1.78, scale = "Mb")

## Add heatmap legend
annoHeatmapLegend(
    plot = bedpePlot, fontcolor = "black",
    x = 7.0, y = 0.25,
    width = 0.10, height = 1, fontsize = 10
)

## Add heatmap legend label
plotText(
    label = "Kb", rot = 90, x = 6.9, y = 0.75,
    just = c("center", "center"), fontsize = 10
)

## Hide page guides
pageGuideHide()
}
