% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictPreeclampsia.R
\name{predictPreeclampsia}
\alias{predictPreeclampsia}
\title{predictPreeclampsia}
\usage{
predictPreeclampsia(betas, ...)
}
\arguments{
\item{betas}{matrix or array of methylation values on the beta scale (0, 1),
where the variables are arranged in rows, and samples in columns.}

\item{...}{feeds into outersect function}
}
\value{
produces a list with components detailed in the \code{mixOmics::predict} R documentation
}
\description{
Uses 45 CpGs to predict early preeclampsia (PE delivered before or at 34 weeks of gestation)
on placental DNA methylation microarray data.
}
\details{
Assigns the class labels "early-PE" or "normotensive" to each sample
and returns a class probability.
}
\section{It is recommended that users apply beta-mixture quantile normalization (BMIQ) to their data}{
prior to prediction. This was the normalization method used on the training data.
}

\examples{

# To predict early preeclampsia on 450k/850k samples

# Load data
library(ExperimentHub)
eh <- ExperimentHub()
query(eh, "eoPredData")

# test object
x_test <- eh[['EH8403']]
x_test \%>\% predictPreeclampsia()

}
