% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregation.R
\name{aggregatePipelineResults}
\alias{aggregatePipelineResults}
\title{aggregatePipelineResults}
\usage{
aggregatePipelineResults(res, pipDef = NULL)
}
\arguments{
\item{res}{A (named) list of results (per dataset), as produced by 
\code{\link{readPipelineResults}} (or `mergePipelineResults`).}

\item{pipDef}{An optional \code{\link{PipelineDefinition}} containing the 
aggregation methods. If omitted, that from the results will be used.}
}
\value{
A list with a slot for each step for which there is an aggregation 
method, or (if no aggregation method available) a list of the 
`stepIntermediateReturnObjects` of `runPipeline`
}
\description{
Aggregates the evaluation and running times of `runPipeline` results. 
Results should be indicated either as a `path`` prefix or as a vector of 
paths to `evaluation\\.rds` files (`resfiles`).
}
\examples{
# we produce mock pipeline results:
pip <- mockPipeline()
datasets <- list( ds1=1:3, ds2=c(5,10,15) )
tmpdir1 <- paste0(tempdir(),'/')
res <- runPipeline(datasets, pipelineDef=pip, output.prefix=tmpdir1,
                   alternatives=list() )
# we read the evaluation files:
res <- readPipelineResults(tmpdir1)
# we aggregate the results (equivalent to the output of `runPipeline`):
res <- aggregatePipelineResults(res)
}
