% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_plots.R
\name{vennplot}
\alias{vennplot}
\title{Venn diagram with VennDiagram}
\usage{
vennplot(
  input.ls,
  palette.vc = RColorBrewer::brewer.pal(9, "Set1")[seq_len(5)],
  title.c = NA,
  sub.c = "",
  cat_pos.vi = NA,
  label_col.c = "black",
  lwd.i = 2,
  inverted.l = FALSE,
  figure.c = "none"
)
}
\arguments{
\item{input.ls}{Named list of vectors to be compared}

\item{palette.vc}{Character vector: Color palette}

\item{title.c}{Character: Plot title}

\item{sub.c}{Character: Plot subtitle}

\item{cat_pos.vi}{Integer vector giving the position (in degrees) of each
category name along the circle, with 0 at 12 o'clock; if NA, (-50, 50),
(-40, 40, 180), (-15, 15, 0, 0), and (0, 287.5, 215, 145, 70) values are used}

\item{label_col.c}{Character: Label color}

\item{lwd.i}{Integer: Width of the circle's circumference}

\item{inverted.l}{Logical: Should the Venn diagram be flipped along its
vertical axis (pairwise venn only)}

\item{figure.c}{Character: Filename for image output (with either .tiff,
.png, or .svg extensions); if 'none' (default) the grid object is displayed
interactively}
}
\value{
invisible grid object
}
\description{
Venn diagram with VennDiagram
}
\examples{
sacurine.se <- reading(system.file("extdata/sacurine", package = "phenomis"))
sacurine.se <- correcting(sacurine.se, figure.c = 'none')
sacurine.se <- sacurine.se[, colData(sacurine.se)[, "sampleType"] != "pool"]
sacurine.se <- transforming(sacurine.se)
sacurine.se <- sacurine.se[, colnames(sacurine.se) != "HU_neg_096_b2"]
# Student's T test
sacurine.se <- hypotesting(sacurine.se, "ttest", "gender")
# Wilcoxon T test
sacurine.se <- hypotesting(sacurine.se, "wilcoxon", "gender")
signif.ls <- list(ttest = which(rowData(sacurine.se)[, "ttest_gender_Female.Male_signif"] > 0),
wilcoxon =  which(rowData(sacurine.se)[, "wilcoxon_gender_Female.Male_signif"] > 0))
vennplot(signif.ls, label_col.c = "black",
title.c = "Signif. features\nwith Student or Wilcoxon tests")
}
