% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_plots.R
\name{gg_volcanoplot}
\alias{gg_volcanoplot}
\title{Volcano plot with ggplot2}
\usage{
gg_volcanoplot(
  fold_change.vn,
  adjusted_pvalue.vn,
  adjust_method.c = "",
  adjust_thresh.n = 0.05,
  label.vc = "",
  title.c = "",
  xlab.c = "Fold Change",
  signif_palette.vc = c(yes = RColorBrewer::brewer.pal(9, "Greens")[8], no =
    RColorBrewer::brewer.pal(9, "Greys")[7]),
  signif_shape.vi = c(yes = 16, no = 1),
  class_name.vc = "",
  class_color.vc = "",
  size.ls = list(class.i = 5, lab.i = 16, point.i = 3, tick.i = 14, title.i = 20),
  figure.c = c("interactive", "interactive_plotly", "my_volcanoplot.pdf",
    "my_volcanoplot.html")[2]
)
}
\arguments{
\item{fold_change.vn}{Numeric vector: fold changes}

\item{adjusted_pvalue.vn}{Numeric vector: (adjusted) p-values}

\item{adjust_method.c}{Character: method for multiple testing correction}

\item{adjust_thresh.n}{Numeric: significance threshold}

\item{label.vc}{Character (vector): either the name of a character column
from the data or a character vector of the same length as the row number of
the data, containing the feature labeling}

\item{title.c}{Character: plot title}

\item{xlab.c}{Character: x label (default: "Fold Change")}

\item{signif_palette.vc}{Character vector: color palette (default 'green4' for
significant features and 'gray' otherwise}

\item{signif_shape.vi}{Integer vector: shapes for significant (respectively,
non significant) features; default is 16 (respectively, 1)}

\item{class_name.vc}{Character vector: names of the two compared class labels}

\item{class_color.vc}{Character vector: colors of the two compared class
labels}

\item{size.ls}{List of sizes for classes (default: 5), xy labels
(default: 16), points (default: 3), ticks (default: 14) and title
(default: 20)}

\item{figure.c}{Character: either 'interactive' (respectively,
'interactive_plotly') for interactive display with ggplot2 (respectively,
with plotly::ggplotly [default]), or 'my_volcanoplot.pdf' (respectively
'my_volcanoplot.html') for figure saving (only the extension matters) with
ggplot2 (respectively, with plotly::ggplotly)}
}
\value{
invisible ggplot2 object
}
\description{
Volcano plot with ggplot2
}
\examples{
sacurine.se <- reading(system.file("extdata/sacurine", package = "phenomis"))
sacurine.se <- correcting(sacurine.se, figure.c = "none")
sacurine.se <- sacurine.se[, colData(sacurine.se)[, "sampleType"] != "pool"]
sacurine.se <- transforming(sacurine.se)
sacurine.se <- hypotesting(sacurine.se, test.c = "wilcoxon",
                                      factor_names.vc = "gender",
                                      figure.c = "none", report.c = "none")
fold.vn <- rowData(sacurine.se)[, "wilcoxon_gender_Female.Male_diff"]
fdr.vn <- rowData(sacurine.se)[, "wilcoxon_gender_Female.Male_BH"]
feat.vc <- rownames(sacurine.se)
gg_volcanoplot(fold.vn,
               fdr.vn,
               label.vc = make.names(feat.vc),
               adjust_method.c = "BH")
feat_signif.vc <-  vapply(seq_along(feat.vc),
                          function(feat.i)
                           ifelse(fdr.vn[feat.i] <= 0.05, feat.vc[feat.i], ""),
                           FUN.VALUE = character(1))
gg_volcanoplot(fold.vn,
               fdr.vn,
               label.vc = make.names(feat_signif.vc),
               adjust_method.c = "BH",
               figure.c = "interactive")
}
