% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/correcting.R
\name{correcting}
\alias{correcting}
\alias{correcting,MultiAssayExperiment-method}
\alias{correcting,SummarizedExperiment-method}
\alias{correcting,MultiDataSet-method}
\alias{correcting,ExpressionSet-method}
\title{correcting}
\usage{
correcting(
  x,
  method.vc = c("loess", "serrf")[1],
  reference.vc = c("pool", "sample")[1],
  loess_span.vn = 1,
  serrf_corvar.vi = 10,
  sample_intensity.c = c("median", "mean", "sum")[2],
  title.c = NA,
  figure.c = c("none", "interactive", "myfile.pdf")[2],
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{correcting}{MultiAssayExperiment}(
  x,
  method.vc = c("loess", "serrf")[1],
  reference.vc = c("pool", "sample")[1],
  loess_span.vn = 1,
  serrf_corvar.vi = 10,
  sample_intensity.c = c("median", "mean", "sum")[2],
  title.c = NA,
  figure.c = c("none", "interactive", "myfile.pdf")[2],
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{correcting}{SummarizedExperiment}(
  x,
  method.vc = c("loess", "serrf")[1],
  reference.vc = c("pool", "sample")[1],
  loess_span.vn = 1,
  serrf_corvar.vi = 10,
  sample_intensity.c = c("median", "mean", "sum")[2],
  title.c = NA,
  figure.c = c("none", "interactive", "myfile.pdf")[2],
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{correcting}{MultiDataSet}(
  x,
  method.vc = c("loess", "serrf")[1],
  reference.vc = c("pool", "sample")[1],
  loess_span.vn = 1,
  serrf_corvar.vi = 10,
  sample_intensity.c = c("median", "mean", "sum")[2],
  title.c = NA,
  figure.c = c("none", "interactive", "myfile.pdf")[2],
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{correcting}{ExpressionSet}(
  x,
  method.vc = c("loess", "serrf")[1],
  reference.vc = c("pool", "sample")[1],
  loess_span.vn = 1,
  serrf_corvar.vi = 10,
  sample_intensity.c = c("median", "mean", "sum")[2],
  title.c = NA,
  figure.c = c("none", "interactive", "myfile.pdf")[2],
  report.c = c("none", "interactive", "myfile.txt")[2]
)
}
\arguments{
\item{x}{An S4 object of class \code{SummarizedExperiment} or
\code{MultiAssayExperiment} (\code{ExpressionSet} and \code{MultiDataSet}
are still supported)}

\item{method.vc}{character of length 1 or the total number of datasets:
method(s) to be used for each dataset (either 'serrf' or 'loess');
for the 'serrf' approach, the seed is internally set to 123 for
reproducibility; in case the parameter is of length 1 and x contains
multiple datasets, the same method will be used for all datasets}

\item{reference.vc}{character of length 1 or the total number of datasets:
sample type to be used as reference for the correction (as indicated in the
'sampleType' column from the colData(x); e.g. 'pool' [default]); should be
set to 'pool' for the 'serrf' method; in case the parameter is of length 1
and x contains multiple datasets, the same reference sample type will be
used for all datasets}

\item{loess_span.vn}{character of length 1 or the total number of datasets:
smoothing parameter for the loess regression; between 0 and 1; (default set
to 1); in case the parameter is of length 1 and x contains multiple datasets,
the same span value will be used for all datasets}

\item{serrf_corvar.vi}{character of length 1 or the total number of datasets:
number of correlated features for the random forest regression;
(default set to 10); in case the parameter is of length 1 and x contains
multiple datasets, the same value will be used for all datasets}

\item{sample_intensity.c}{character(1): metric to be used when displaying
the sample intensities}

\item{title.c}{character(1): Graphic title: if NA [default] the
'title' slot from the experimentData will be used (metadata)}

\item{figure.c}{character(1): File name with '.pdf' extension for the figure;
if 'interactive' (default), figures will be displayed interactively;
if 'none', no figure will be generated}

\item{report.c}{character(1): File name with '.txt' extension for the printed
results (call to sink()'); if 'interactive' (default), messages will be
printed on the screen; if 'none', no verbose will be generated}
}
\value{
\code{SummarizedExperiment} or \code{MultiAssayExperiment}
(or \code{ExpressionSet} and \code{MultiDataSet}) including the corrected
intensities in the assay matrix (matrices)
}
\description{
Signal drift and batch effect correction. The normalization strategy relies
on the measurements of a pooled (or QC) sample injected periodically:
for each variable, a regression model is fitted to the values of the pool and
subsequently used to adjust the intensities of the samples of interest (van
der Kloet et al, 2009; Dunn et al, 2011). In case the number of pool
observations is below 5, the linear method is used (for all variables) and a
warning is generated. In case no pool is available, the samples themselves
can be used to computed the regression model (Thevenot et al., 2015). The
sample metadata of each datasets (e.g. colData Data Frames) must contain
3 columns: 1) 'sampleType' (character): only the 'sample' or 'pool' values
can be used to indicate the reference samples for the correction, 2)
'injectionOrder' (integer): order of injection in the instrument, and 3)
'batch' (character): batch name(s).
}
\examples{
sacurine.se <- reading(system.file("extdata/sacurine", package = "phenomis"))
sacurine.se <- correcting(sacurine.se)

# MultiDataSet (to be done)
}
