% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadGEO.R
\name{getES}
\alias{getES}
\title{Load ExpressionSet by GEO identifier}
\usage{
getES(
  name,
  type = NA,
  destdir = getPhantasusConf("cache_folders")$geo_path,
  mirrorPath = getPhantasusConf("geo_mirrors")
)
}
\arguments{
\item{name}{String, containing GEO identifier of the dataset.
It should start with 'GSE' or 'GDS' and can include exact GPL
to annotate dataset, separated with dash ('-') from the identifier.}

\item{type}{Type of the dataset: 'GSE' or 'GDS'. If not specified,
the function will take first three letters
of \code{name} variable as type.}

\item{destdir}{Directory for caching loaded Series and GPL
files from GEO database.}

\item{mirrorPath}{URL string which specifies the source of matrices.}
}
\value{
List of ExpressionSet objects, that were available by given
    in \code{name} variable GEO identifier.
}
\description{
\code{getES} return the ExpressionSet object(s) corresponding
    to GEO identifier.
}
\examples{
\dontrun{
    getES('GSE14308', type = 'GSE', destdir = 'cache')
    getES('GSE27112')
    getES('GDS4922')
}

}
