% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlatePCs.R
\name{correlatePCs}
\alias{correlatePCs}
\title{Principal components (cor)relation with experimental covariates}
\usage{
correlatePCs(pcaobj, coldata, pcs = 1:4)
}
\arguments{
\item{pcaobj}{A \code{prcomp} object}

\item{coldata}{A \code{data.frame} object containing the experimental
covariates}

\item{pcs}{A numeric vector, containing the corresponding PC number}
}
\value{
A \code{data.frame} object with computed p values for each covariate
and for each principal component
}
\description{
Computes the significance of (cor)relations between PCA scores and the sample
experimental covariates, using Kruskal-Wallis test for categorial variables
and the \code{cor.test} based on Spearman's correlation for continuous
variables
}
\examples{
library(DESeq2)
dds <- makeExampleDESeqDataSet_multifac(betaSD_condition = 3, betaSD_tissue = 1)
rlt <- DESeq2::rlogTransformation(dds)
pcaobj <- prcomp(t(assay(rlt)))
correlatePCs(pcaobj, colData(dds))

}
