% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aesPC_calculate_LARS.R
\name{lars.lsa}
\alias{lars.lsa}
\title{Least Angle Regression and LASSO Regression}
\usage{
lars.lsa(
  Sigma0,
  b0,
  n,
  type = c("lar", "lasso"),
  max.steps = NULL,
  eps = .Machine$double.eps,
  adaptive = TRUE,
  para = NULL
)
}
\arguments{
\item{Sigma0}{A Grammian / covariance matrix of pathway predictors.}

\item{b0}{An eigenvector of \code{Sigma0}.}

\item{n}{The sample size.}

\item{type}{Option between \code{"lar"} and \code{"lasso"}. Defaults to
\code{"lasso"}.}

\item{max.steps}{How many steps should the LAR or LASSO algorithms take?
Defaults to 8 times the pathway dimension.}

\item{eps}{What should we consider to be numerically 0? Defaults to the
machine's default error limit for doubles (\code{.Machine$double.eps}).}

\item{adaptive}{Ignore.}

\item{para}{Ignore.}
}
\value{
An object of class \code{"lars"}.
}
\description{
These are all variants of LASSO, and provide the entire
  sequence of coefficients and fits, starting from zero to the least
  squares fit.
}
\details{
LARS is described in detail in Efron, Hastie, Johnstone and
  Tibshirani (2002). With the \code{"lasso"} option, it computes the complete
  LASSO solution simultaneously for \emph{all} values of the shrinkage
  parameter in the same computational cost as a least squares fit. This
  function is adapted from the \code{\link[lars]{lars}} function in the
  \code{lars} package to apply to covariance or Grammian pathway design
  matrices.
}
\examples{
  # DO NOT CALL THIS FUNCTION DIRECTLY.
  # Use AESPCA_pVals() instead
  
\dontrun{
  X_mat <- as.matrix(colonSurv_df[, 5:50])
  X_mat <- scale(X_mat)
  
  XtX <- t(X_mat) \%*\% X_mat
  A_mat <- svd(XtX)$v
  
  lars.lsa(
    Sigma0 = XtX,
    b0 = A_mat[, 1] * sign(A_mat[1, 1]),
    n = ncol(X_mat)
  )
}
  
}
\seealso{
\url{https://web.stanford.edu/~hastie/Papers/LARS/LeastAngle_2002.pdf}
}
\keyword{internal}
