% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathwayPlots.R
\name{pathwayPlots}
\alias{pathwayPlots}
\title{Plot pathway enrichment results}
\usage{
pathwayPlots(
  pathwayEnrichmentResults,
  columns = 1,
  specificTopPathways = "any",
  specificPathways = "any",
  colourValues = c("blue", "red"),
  nameWidth = 35,
  nameRows = 1,
  xAngle = "angled",
  maxPVal = 50,
  intercepts = NA,
  includeGeneRatio = FALSE,
  size = 4,
  legendMultiply = 1,
  showNumGenes = FALSE,
  pathwayPosition = "right",
  newGroupNames = NA,
  fontSize = 12
)
}
\arguments{
\item{pathwayEnrichmentResults}{Data frame of results from the function
\code{enrichPathway}}

\item{columns}{Number of columns to split the pathways across, particularly
relevant if there are many significant pathways. Can specify up to 3
columns, with a default of 1.}

\item{specificTopPathways}{Only plot pathways from a specific vector of
"topLevelPathway". Defaults to "any" which includes all pathway results, or
see \code{unique(pathwayEnrichmentResults$topLevelPathway)} (i.e. the
input) for possible values.}

\item{specificPathways}{Only plot specific pathways. Defaults to "any".}

\item{colourValues}{Length-two character vector of colours to use for the
scale. Defaults to \code{c("blue", "red")}.}

\item{nameWidth}{How many characters to show for pathway name before
truncating? Defaults to 35.}

\item{nameRows}{For pathway names (y axis), how many rows (lines) should
names wrap across when they're too long? Defaults to 1.}

\item{xAngle}{Angle of x axis labels, set to "angled" (45 degrees),
"horizontal" (0 degrees), or "vertical" (90 degrees).}

\item{maxPVal}{P values below \code{10 ^ -maxPVal} will be set to that value.}

\item{intercepts}{Add vertical lines to separate different groupings, by
providing a vector of intercepts (e.g. \code{c(1.5, 2.5)}).
Defaults to \code{NA}.}

\item{includeGeneRatio}{Boolean (FALSE). Should the gene ratio be included as
an aesthetic mapping?If so, then it is attributed to the size of the
triangles.}

\item{size}{Size of points if not scaling to gene ratio. Defaults to 4.}

\item{legendMultiply}{Size of the legend, e.g. increase if there are a lot of
pathways which makes the legend small and unreadable by comparison.
Defaults to 1, i.e. no increase in legend size.}

\item{showNumGenes}{Boolean, defaults to FALSE. Show the number of genes for
each comparison as brackets under the comparison's name.}

\item{pathwayPosition}{Whether to have the y-axis labels (pathway names) on
the left or right side. Default is "right".}

\item{newGroupNames}{If you want to change the names of the comparisons to
different names. Input a vector in the order as they appear.}

\item{fontSize}{Base font size for all text elements of the plot. Defaults to
12.}
}
\value{
A plot of enriched pathways; a "ggplot" object
}
\description{
Creates a plot to visualize and compare pathway enrichment
results from multiple DE comparisons. Can automatically assign each pathway
into an informative top-level category.
}
\examples{
data("sigoraExamples")
pathwayPlots(sigoraExamples, columns=2)

}
\seealso{
\url{https://github.com/hancockinformatics/pathlinkR}
\url{https://bioconductor.org/packages/fgsea/}
}
