% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eruption.R
\name{eruption}
\alias{eruption}
\title{Create a volcano plot of RNA-Seq results}
\usage{
eruption(
  rnaseqResult,
  columnFC = NA,
  columnP = NA,
  pCutoff = 0.05,
  fcCutoff = 1.5,
  labelCutoffs = FALSE,
  baseColour = "steelblue4",
  nonsigColour = "lightgrey",
  alpha = 0.5,
  pointSize = 1,
  title = NA,
  nonlog2 = FALSE,
  xaxis = NA,
  yaxis = NA,
  highlightGenes = c(),
  highlightColour = "red",
  highlightName = "Selected",
  label = "auto",
  n = 10,
  manualGenes = c(),
  removeUnannotated = TRUE,
  labelSize = 3.5,
  pad = 1.4
)
}
\arguments{
\item{rnaseqResult}{Data frame of RNASeq results, with Ensembl gene IDs as
rownames. Can be a "DESeqResults" or "TopTags" object, or a simple data
frame. See "Details" for more information.}

\item{columnFC}{Character; Column to plot along the x-axis, typically log2
fold change values. Only required when \code{rnaseqResult} is a simple data
frame. Defaults to NA.}

\item{columnP}{Character; Column to plot along the y-axis, typically nominal
or adjusted p values. Only required when \code{rnaseqResult} is a simple data
frame. Defaults to NA.}

\item{pCutoff}{Adjusted p value cutoff, defaults to < 0.05}

\item{fcCutoff}{Absolute fold change cutoff, defaults to > 1.5}

\item{labelCutoffs}{Logical; Should cutoff lines for p value and fold change
be labeled? Size of the label is controlled by \code{labelSize}. Defaults to
FALSE.}

\item{baseColour}{Colour of points for all significant DE genes
("steelblue4")}

\item{nonsigColour}{Colour of non-significant DE genes ("lightgrey")}

\item{alpha}{Transparency of the points (0.5)}

\item{pointSize}{Size of the points (1)}

\item{title}{Title of the plot}

\item{nonlog2}{Show non-log2 fold changes instead of log2 fold change (FALSE)}

\item{xaxis}{Length-two numeric vector to manually specify limits of the
x-axis in log2 fold change; defaults to NA which lets ggplot2 determine the
best values.}

\item{yaxis}{Length-two numeric vector to manually specify limits of the
y-axis (in -log10). Defaults to NA which lets ggplot2 determine the best
values.}

\item{highlightGenes}{Vector of genes to emphasize by colouring differently
(e.g. genes of interest). Must be Ensembl IDs.}

\item{highlightColour}{Colour for the genes specified in \code{highlightGenes}}

\item{highlightName}{Optional name to call the \code{highlightGenes} (e.g.
Unique, Shared, Immune related, etc.)}

\item{label}{When set to "auto" (default), label the top \code{n} up- and
down-regulated DE genes. When set to "highlight", label top \code{n} up- and
down-regulated genes provided in \code{highlightGenes}. When set to "manual"
label a custom selection of genes provided in \code{manualGenes}.}

\item{n}{number of top up- and down-regulated genes to label. Applies when
\code{label} is set to "auto" or "highlight".}

\item{manualGenes}{If \code{label="manual"}, these are the genes to be
specifically label. Can be HGNC symbols or Ensembl gene IDs.}

\item{removeUnannotated}{Boolean (TRUE): Remove genes without annotations
(no HGNC symbol).}

\item{labelSize}{Size of font for labels (3.5)}

\item{pad}{Padding of labels; adjust this if the labels overlap}
}
\value{
Volcano plot of genes from an RNA-Seq experiment; a "ggplot" object
}
\description{
Creates a volcano plot of genes from RNA-Seq results, with
various options for tweaking the appearance. Ensembl gene IDs should be the
rownames of the input object.
}
\details{
The input to \code{eruption()} can be of class "DESeqResults" (from
\code{DESeq2}), "TopTags" (\code{edgeR}), or a simple data frame. When providing
either of the former, the columns to plot are automatically pulled
("log2FoldChange" and "padj" for DESeqResults, or "logFC" and "FDR" for
TopTags). Otherwise, the arguments "columnFC" and "columnP" must be
specified. If one wishes to override the default behaviour for
"DESeqResults" or "TopTags" (e.g. plot nominal p values on the y-axis),
convert those objects to data frames, then supply "columnFC" and "columnP".

The argument \code{highlightGenes} can be used to draw attention to a specific
set of genes, e.g. those from a pathway of interest. Setting the argument
\code{label="highlight"} will also mean those same genes (at least some of them)
will be given labels, further emphasizing them in the volcano plot.

Since this function returns a ggplot object, further custom changes could
be applied using the standard ggplot2 functions (\code{labs()}, \code{theme()},
etc.).
}
\examples{
data("exampleDESeqResults")
eruption(rnaseqResult=exampleDESeqResults[[1]])

}
\seealso{
\url{https://github.com/hancockinformatics/pathlinkR}
}
