% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm_functions.R
\name{targetedGenes}
\alias{targetedGenes}
\title{targetedGenes}
\usage{
targetedGenes(x, tfs)
}
\arguments{
\item{x}{an object of class "panda"}

\item{tfs}{transcription factors to query}
}
\value{
A vector of targeted genes
}
\description{
Gets a set of genes targeted by a specified transcription factor.  This function can be applied to a graph that
is not complete, subsetting the edges which have non-zero edge weight.  See function topEdges for dichotomizing edgeweights.
}
\examples{
\donttest{
data(pandaToyData)
pandaRes <- panda(pandaToyData$motif,
           pandaToyData$expression,pandaToyData$ppi,hamming=.001)
topPandaRes <- topedges(pandaRes,1000)
targetedGenes(topPandaRes,c("AR","ELK1"))
}
data(pandaResult)
topPandaRes <- topedges(pandaResult,1000)
}
\keyword{keywords}
