% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PaIRKAT.R
\name{PaIRKAT}
\alias{PaIRKAT}
\title{Perform PaIRKAT on the output from the GatherNetworks function}
\usage{
PaIRKAT(formula.H0, networks, tau = 1)
}
\arguments{
\item{formula.H0}{The null model in the "formula" format used
in \code{\link[stats]{lm}} and \code{\link[stats]{glm}} functions}

\item{networks}{networks object obtained
with \code{\link[pairkat]{GatherNetworks}}}

\item{tau}{A parameter to control the amount of smoothing,
analagous to a bandwidth parameter in kernel smoothing. We found 1 often
gave reasonable results, as over-smoothing can lead to
inflated Type I errors.}
}
\value{
a list object containing the formula call and results by pathway
}
\description{
Pathway Integrated Regression-based Kernel Association Test (PaIRKAT) is a
model framework for assessing statistical relationships between networks
and some outcome of interest while adjusting for
potential confounders and covariates.

Use of PaIRKAT is motivated by the analysis of networks of metabolites
from a metabolomics assay and the relationship of those networks with a
phenotype or clinical outcome of interest, though the method can be
generalized to other domains.
}
\details{
The PaIRKAT method is to update the feature matrix, \eqn{Z},
with the regularized normalized Laplacian, \eqn{L_R}, before performing
the kernel association test. \eqn{L_R} is calculated using a "linear"
regularization, \deqn{L_R = (I +\tau L)^-1,} where \eqn{I} is the identity
matrix, \eqn{\tau} is a regularization parameter that controls the amount
of smoothing, and \eqn{L} is the graph's normalized Laplacian. The updated
feature matrix, \eqn{Z*L_R} is matrix used for the kernel association
test. \cr
The linear regularization and Gaussian kernel is used for all tests.
See Carpenter 2021 for complete details on PaIRKAT and Smola 2003
for information about graph regularization
}
\examples{
data(smokers)

# Query KEGGREST API
networks <- GatherNetworks(SE = smokers, keggID = "kegg_id",
species = "hsa", minPathwaySize = 5)

# Run PaIRKAT Analysis
output <- PaIRKAT(log_FEV1_FVC_ratio ~ age, networks = networks)

# View Results
output$results

}
\references{
Carpenter CM, Zhang W, Gillenwater L, Severn C, Ghosh T, Bowler R, et al.
PaIRKAT: A pathway integrated regression-based kernel association test
with applications to metabolomics and COPD phenotypes.
bioRxiv. 2021 Apr 26;2021.04.23.440821.

Smola AJ, Kondor R. Kernels and Regularization on Graphs.
In: Schölkopf B, Warmuth MK, editors. Learning Theory and Kernel Machines.
Berlin, Heidelberg: Springer Berlin Heidelberg; 2003. p. 144–58.
(Goos G, Hartmanis J, van Leeuwen J, editors. Lecture Notes in Computer
Science; vol. 2777). http://link.springer.com/10.1007/978-3-540-45167-9_12
}
