#' Calculate Probability-Based Distance
#'
#' Calculate distance based on PXY and PXPY.
#'
#' @param pxy (list) Joint probability generated by PXY fuction.
#'
#' @param pxpy (list) Product of marginal probability generated by PXPY fuction.
#'
#' @param method (character) Method for calculating distance, either PXY-PXPY
#' ("difference") or mutual information ("mi").
#'
#' @return (list) Distance values.
#'
#' @author DING, HONGXU (hd2326@columbia.edu)
#'
#' @importFrom utils txtProgressBar
#' @importFrom utils setTxtProgressBar
#' 
#' @keywords internal

P_dist <- function(pxy, pxpy, method=c("difference", "mi")){
    pb <- txtProgressBar(min = 1, max = length(pxy), style = 3)
    dist <- lapply(seq_len(length(pxy)), function(i, pxy, pxpy, method, pb){
        setTxtProgressBar(pb, i)
        if (method == "difference") dist <- pxy[[i]]-pxpy[[i]]
        else if (method == "mi") dist <- pxy[[i]]*log2(pxy[[i]]/pxpy[[i]])
        else (message("method should be difference or mi"))
        dist[dist < 0 | !is.finite(dist)] <- 0
        sum(dist)}, pxy=pxy, pxpy=pxpy, method=method, pb=pb)
    names(dist) <- names(pxy)
    return(dist)}
