% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-AllClasses.R
\docType{class}
\name{padmaResults-class}
\alias{padmaResults-class}
\alias{padmaResults}
\title{padmaResults object and constructor}
\usage{
padmaResults(
  SummarizedExperiment,
  pathway_name = NULL,
  pathway_gene_deviation = NULL,
  MFA_results = NULL,
  ngenes = NULL,
  imputed_genes = NULL,
  removed_genes = NULL
)
}
\arguments{
\item{SummarizedExperiment}{a \code{RangedSummarizedExperiment} of 
\code{padma} results}

\item{pathway_name}{The name of the pathway, if applicable}

\item{pathway_gene_deviation}{Per-gene contributions to each 
individualized pathway deviation score}

\item{MFA_results}{List of all detailed results from the MFA}

\item{ngenes}{Number of genes used in the pathway deviation score calculation}

\item{imputed_genes}{Names of genes, per omic, for which data imputation was 
used to replace missing values}

\item{removed_genes}{Names of genes, per omic, which were filtered from the 
analysis due to low variation}
}
\value{
a padmaResults object
}
\description{
\code{padmaResults} is a subclass of \code{RangedSummarizedExperiment},
used to store the individualized pathway deviation scores as well as some 
additional information useful about the pathway name (\code{pathway_name}), 
the gene-level contributions to each deviation score 
(\code{pathway_gene_deviation}), a full set of 
outputs related to the MFA (\code{MFA_results}, and the number
of genes used in the analysis as well as the names of those for which data 
imputation or filtering was required (\code{ngenes}, \code{imputed_genes}, 
and \code{removed_genes}, respectively).
}
\details{
This constructor function would not typically be used by 'end users'.
This simple class extends the \code{RangedSummarizedExperiment} class of the
SummarizedExperiment package
to allow other packages to write methods for results
objects from the padma package. It is used by \code{\link{padmaRun}}
to wrap up the results table.
}
