% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packsToFasta.R
\name{packsToFasta}
\alias{packsToFasta}
\title{Save packFinder Results in FASTA Format (.fasta)}
\usage{
packsToFasta(packMatches, file, Genome)
}
\arguments{
\item{packMatches}{taframe containing genomic ranges and names referring 
to sequences to be extracted. Can be obtained from 
\code{\link{packSearch}} or generated from a 
\code{\link[GenomicRanges:GRanges-class]{GRanges}} object, 
after conversion to a dataframe. Must contain the 
following features:
\itemize{
    \item start - the predicted element's start base 
    sequence position.
    \item end - the predicted element's end 
    base sequence position.
    \item seqnames - character string 
    referring to the sequence name in \code{Genome} to 
    which \code{start} and \code{end} refer to.
}}

\item{file}{FASTA file save path.}

\item{Genome}{A DNAStringSet object containing sequences referred to 
in \code{packMatches} (the object originally used to 
predict the transposons \code{\link{packSearch}}).}
}
\value{
Save location of Fasta file.
}
\description{
Saves a dataframe of potential Pack-TYPE elements, 
usually generated via \code{\link{packSearch}}. 
May be retrieved using \code{\link{getPacksFromFasta}}.
}
\examples{
data(arabidopsisThalianaRefseq)
data(packMatches)

packsToFasta(
    packMatches, 
    system.file("extdata", "packMatches.fasta", package = "packFinder"), 
    arabidopsisThalianaRefseq
)

}
\seealso{
\code{\link{getPacksFromFasta}}, \code{\link{packSearch}}
}
\author{
Jack Gisby
}
