% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTsds.R
\name{getTsds}
\alias{getTsds}
\title{Get Flanking Terminal Site Duplication Sequences}
\usage{
getTsds(tirMatches, Genome, tsdLength, strand = "+", output = "character")
}
\arguments{
\item{tirMatches}{A dataframe containing genomic ranges and names referring 
to TIR sequences or predicted Pack-TYPE transposable 
elements. Should be in the format used by 
\code{\link{packSearch}}.}

\item{Genome}{A \code{\link[Biostrings:XStringSet-class]{DNAStringSet}} 
object containing sequences referred to in \code{tirMatches}.}

\item{tsdLength}{The length of the TSD region to be retrieved (integer).}

\item{strand}{The strand of the TIR; "+" for forward, "-" for reverse. 
If the TSD sequences of transposable elements are being 
predicted, then this parameter can be left as default 
("+"); if the TSD sequences of TIRs are being found then 
the strand direction must be supplied.}

\item{output}{The type of object to be returned:
\itemize{
    \item output = "DNAStringSet", returns a 
    \code{\link[Biostrings:XStringSet-class]{DNAStringSet}} 
    object.
    \item output = "character", returns a 
    \code{character} vector (default).
}}
}
\value{
Flanking TSD sequences as a vector of characters, or if 
output is specified as "DNAStringSet", TSD sequences 
will be returned as a 
\code{\link[Biostrings:XStringSet-class]{DNAStringSet}} 
object.
}
\description{
Gets the flanking TSD sequences of TIRs or predicted 
Pack-TYPE transposable elements. A dataframe of these 
elements can be in \code{tirMatches}.
}
\details{
Called by \code{\link{packSearch}}. It is recommended 
to use the general pipeline function 
\code{\link{packSearch}} for identification of potential 
pack elements, which returns TSD sequences as a feature 
of results, however each stage may be called individually.
}
\examples{
data(arabidopsisThalianaRefseq)
data(packMatches)

tsdSeqs <- getTsds(packMatches, arabidopsisThalianaRefseq, 3)

}
\seealso{
\code{\link[Biostrings:XStringSet-class]{DNAStringSet}},
\code{\link{packSearch}}, \code{tirMatches}
}
\author{
Jack Gisby
}
