% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_orthologs_custom.R
\name{map_orthologs_custom}
\alias{map_orthologs_custom}
\title{Map orthologs: gprofiler}
\usage{
map_orthologs_custom(
  gene_map,
  input_species,
  output_species,
  input_col,
  output_col,
  verbose = TRUE
)
}
\arguments{
\item{gene_map}{A \link[base]{data.frame} that maps the current gene names
to new gene names. 
This function's behaviour will adapt to different situations as follows: 
\describe{
\item{\code{gene_map=<data.frame>}}{When a data.frame containing the
gene key:value columns 
(specified by \code{input_col} and \code{output_col}, respectively)
is provided, this will be used to perform aggregation/expansion.}
\item{\code{gene_map=NULL} and \code{input_species!=output_species}}{
A \code{gene_map} is automatically generated by
 \link[orthogene]{map_orthologs} to perform inter-species 
 gene aggregation/expansion.}
\item{\code{gene_map=NULL} and \code{input_species==output_species}}{
A \code{gene_map} is automatically generated by
 \link[orthogene]{map_genes} to perform within-species 
 gene gene symbol standardization and aggregation/expansion.}
}}

\item{input_species}{Name of the input species (e.g., "mouse","fly").
Use \link[orthogene]{map_species} to return a full list
of available species.}

\item{output_species}{Name of the output species (e.g. "human","chicken").
Use \link[orthogene]{map_species} to return a full list
 of available species.}

\item{input_col}{Column name within \code{gene_map} with gene names matching 
the row names of \code{X}.}

\item{output_col}{Column name within \code{gene_map} with gene names
that you wish you map the row names of \code{X} onto.}

\item{verbose}{Print messages.}
}
\value{
Ortholog map \code{data.frame}
}
\description{
Map orthologs from one species to another
using a custom \code{gene_map} table.
}
\keyword{internal}
